/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextAware;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ReadOnlyResourceRepositoryBase;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.utils.Supplier;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.internal.MetaUtils;
import io.crnk.meta.model.MetaElement;
import java.util.ArrayList;
import java.util.Collection;

public class MetaResourceRepositoryImpl<T>
extends ReadOnlyResourceRepositoryBase<T, String>
implements HttpRequestContextAware {
    private final Supplier<MetaLookup> lookupSupplier;
    private HttpRequestContextProvider requestContextProvider;

    public MetaResourceRepositoryImpl(Supplier<MetaLookup> lookupSupplier, Class<T> resourceClass) {
        super(resourceClass);
        this.lookupSupplier = lookupSupplier;
    }

    public T findOne(String id, QuerySpec querySpec) {
        MetaElement wrappedElement;
        HttpRequestContext requestContext = this.requestContextProvider.getRequestContext();
        QueryContext queryContext = requestContext.getQueryContext();
        MetaLookup lookup = (MetaLookup)this.lookupSupplier.get();
        MetaElement metaElement = lookup.getMetaById().get(id);
        Class resourceClass = this.getResourceClass();
        if (metaElement != null && resourceClass.isInstance(metaElement) && (wrappedElement = MetaUtils.adjustForRequest(lookup, metaElement, queryContext)) != null) {
            return (T)metaElement;
        }
        throw new ResourceNotFoundException(id);
    }

    public ResourceList<T> findAll(QuerySpec querySpec) {
        MetaLookup lookup = (MetaLookup)this.lookupSupplier.get();
        Collection<T> values = this.filterByType(lookup.getMetaById().values());
        return querySpec.apply(values);
    }

    private Collection<T> filterByType(Collection<MetaElement> values) {
        HttpRequestContext requestContext = this.requestContextProvider.getRequestContext();
        QueryContext queryContext = requestContext.getQueryContext();
        ArrayList<MetaElement> results = new ArrayList<MetaElement>();
        Class resourceClass = this.getResourceClass();
        MetaLookup lookup = (MetaLookup)this.lookupSupplier.get();
        for (MetaElement element : values) {
            MetaElement wrappedElement;
            if (!resourceClass.isInstance(element) || (wrappedElement = MetaUtils.adjustForRequest(lookup, element, queryContext)) == null) continue;
            results.add(wrappedElement);
        }
        return results;
    }

    public void setHttpRequestContextProvider(HttpRequestContextProvider requestContextProvider) {
        this.requestContextProvider = requestContextProvider;
    }
}

