/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal.typed;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.meta.internal.typed.MetaDataObjectProviderBase;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.provider.MetaFilter;
import java.lang.reflect.Type;

public abstract class MetaDataObjectProvider
extends MetaDataObjectProviderBase<MetaDataObject>
implements MetaFilter {
    @Override
    public MetaElement create(Type type) {
        Class rawClazz = ClassUtils.getRawType((Type)type);
        Class superClazz = rawClazz.getSuperclass();
        MetaElement superMeta = null;
        if (superClazz != Object.class && superClazz != null) {
            superMeta = this.context.allocate(superClazz);
        }
        MetaDataObject meta = this.newDataObject();
        meta.setElementType(meta);
        meta.setName(rawClazz.getSimpleName());
        meta.setImplementationType(type);
        meta.setSuperType((MetaDataObject)superMeta);
        if (superMeta != null) {
            ((MetaDataObject)superMeta).addSubType(meta);
        }
        this.createAttributes(meta);
        return meta;
    }

    protected abstract MetaDataObject newDataObject();

    @Override
    public void onInitialized(MetaElement element) {
        if (element instanceof MetaAttribute && element.getParent().getClass() == this.getMetaClass()) {
            MetaAttribute attr = (MetaAttribute)element;
            MetaDataObject parent = attr.getParent();
            Type implementationType = PropertyUtils.getPropertyType(parent.getImplementationClass(), (String)attr.getName());
            MetaElement metaType = this.context.allocate(implementationType);
            attr.setType(metaType.asType());
        }
    }

    protected abstract Class<? extends MetaElement> getMetaClass();

    @Override
    public void onInitializing(MetaElement element) {
    }

    @Override
    public MetaElement adjustForRequest(MetaElement element, QueryContext queryContext) {
        return element;
    }
}

