/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal.typed;

import io.crnk.core.engine.information.bean.BeanAttributeInformation;
import io.crnk.core.engine.information.bean.BeanInformation;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.meta.internal.MetaUtils;
import io.crnk.meta.internal.typed.TypedMetaElementFactory;
import io.crnk.meta.internal.typed.TypedMetaElementFactoryContext;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MetaDataObjectProviderBase<T extends MetaDataObject>
implements TypedMetaElementFactory {
    protected TypedMetaElementFactoryContext context;

    @Override
    public void init(TypedMetaElementFactoryContext context) {
        this.context = context;
    }

    protected void createAttributes(T meta) {
        Class<?> implClass = ((MetaType)meta).getImplementationClass();
        BeanInformation beanInformation = BeanInformation.get(implClass);
        for (String name : beanInformation.getAttributeNames()) {
            BeanAttributeInformation attrInformation = beanInformation.getAttribute(name);
            if (attrInformation.getGetter() == null || this.isIgnored(attrInformation) || attrInformation.getGetter().getDeclaringClass() != implClass) continue;
            MetaAttribute attribute = this.createAttribute(meta, MetaUtils.firstToLower(name));
            attribute.setReadMethod(attrInformation.getGetter());
            attribute.setWriteMethod(attrInformation.getSetter());
            attribute.setSortable(true);
            attribute.setFilterable(true);
            if (attrInformation.getSetter() != null) {
                attribute.setInsertable(true);
                attribute.setUpdatable(true);
            }
            this.initAttribute(attribute);
        }
    }

    protected boolean isIgnored(BeanAttributeInformation information) {
        return false;
    }

    protected void initAttribute(MetaAttribute attribute) {
    }

    private List<String> getOrderedPropertyNames(List<Field> fields, List<Method> getters, Map<String, Field> fieldMap) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (Field field : fields) {
            propertyNames.add(field.getName());
        }
        for (Method method : getters) {
            String name = ClassUtils.getGetterFieldName((Method)method);
            if (fieldMap.containsKey(name)) continue;
            propertyNames.add(name);
        }
        return propertyNames;
    }

    private Map<String, Field> toFieldMap(List<Field> members) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field member : members) {
            map.put(member.getName(), member);
        }
        return map;
    }

    private Map<String, Method> toGetterMethodMap(List<Method> members) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method member : members) {
            String name = ClassUtils.getGetterFieldName((Method)member);
            map.put(name, member);
        }
        return map;
    }

    protected MetaAttribute createAttribute(T metaDataObject, String name) {
        MetaAttribute attr = new MetaAttribute();
        attr.setName(MetaUtils.firstToLower(name));
        attr.setParent((MetaElement)metaDataObject, true);
        attr.setFilterable(true);
        attr.setSortable(true);
        return attr;
    }
}

