/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.provider;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.meta.model.MetaArrayType;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaEnumType;
import io.crnk.meta.model.MetaListType;
import io.crnk.meta.model.MetaLiteral;
import io.crnk.meta.model.MetaMapType;
import io.crnk.meta.model.MetaPrimitiveType;
import io.crnk.meta.model.MetaSetType;
import io.crnk.meta.model.MetaType;
import io.crnk.meta.provider.MetaPartition;
import io.crnk.meta.provider.MetaPartitionContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;

public abstract class MetaPartitionBase
implements MetaPartition {
    protected MetaPartitionContext context;
    protected Map<Type, MetaElement> typeMapping = new HashMap<Type, MetaElement>();
    protected Set<Type> nonUniqueTypes = new HashSet<Type>();
    protected MetaPartition parent;

    @Override
    public void init(MetaPartitionContext context) {
        this.context = context;
    }

    @Override
    public MetaElement getMeta(Type type) {
        MetaElement metaElement = this.typeMapping.get(type);
        if (metaElement == null && this.parent != null) {
            metaElement = this.parent.getMeta(type);
        }
        PreconditionUtil.verify((metaElement != null ? 1 : 0) != 0, (String)"meta element not found for %s", (Object[])new Object[]{type});
        return metaElement;
    }

    @Override
    public boolean hasMeta(Type type) {
        return this.typeMapping.containsKey(type) || this.parent != null && this.parent.hasMeta(type);
    }

    protected Optional<MetaElement> addElement(Type type, MetaElement element) {
        this.context.addElement(element);
        if (type != null && !this.nonUniqueTypes.contains(type)) {
            if (this.typeMapping.containsKey(type)) {
                this.nonUniqueTypes.add(type);
                this.typeMapping.remove(type);
            } else {
                this.typeMapping.put(type, element);
            }
        }
        return Optional.of(element);
    }

    @Override
    public final Optional<MetaElement> allocateMetaElement(final Type type) {
        if (this.typeMapping.containsKey(type)) {
            return Optional.of(this.typeMapping.get(type));
        }
        return this.context.runDiscovery(new Callable<Optional<MetaElement>>(){

            @Override
            public Optional<MetaElement> call() {
                Optional<MetaElement> element;
                if (MetaPartitionBase.this.parent != null && (element = MetaPartitionBase.this.parent.allocateMetaElement(type)).isPresent()) {
                    return element;
                }
                if (MetaPartitionBase.this.typeMapping.containsKey(type)) {
                    return Optional.of(MetaPartitionBase.this.typeMapping.get(type));
                }
                if (ClassUtils.getRawType((Type)type) == Optional.class && (element = MetaPartitionBase.this.allocateMetaElement(((ParameterizedType)type).getActualTypeArguments()[0])).isPresent()) {
                    return element;
                }
                if (type instanceof ParameterizedType && (element = MetaPartitionBase.this.allocateMap((ParameterizedType)type)).isPresent()) {
                    return element;
                }
                element = MetaPartitionBase.this.allocateCollectionType(type);
                if (element.isPresent()) {
                    return element;
                }
                element = MetaPartitionBase.this.allocateEnumType(type);
                if (element.isPresent()) {
                    return element;
                }
                Optional<MetaElement> optElement = MetaPartitionBase.this.doAllocateMetaElement(type);
                PreconditionUtil.assertNotNull((String)"must be not null", optElement);
                if (optElement.isPresent() && !optElement.get().hasId() && optElement.get() instanceof MetaType) {
                    PreconditionUtil.assertTrue((String)"must have an id", (boolean)optElement.get().hasId());
                }
                return optElement;
            }
        });
    }

    protected abstract Optional<MetaElement> doAllocateMetaElement(Type var1);

    protected Optional<MetaElement> allocateEnumType(Type type) {
        Class clazz;
        if (type instanceof Class && (clazz = (Class)type).isEnum()) {
            MetaEnumType enumType = new MetaEnumType();
            enumType.setElementType(enumType);
            enumType.setImplementationType(type);
            enumType.setName(clazz.getSimpleName());
            for (Object literalObj : clazz.getEnumConstants()) {
                MetaLiteral literal = new MetaLiteral();
                literal.setName(literalObj.toString());
                literal.setParent(enumType, true);
            }
            return this.addElement(type, enumType);
        }
        return Optional.empty();
    }

    private Optional<MetaElement> allocateCollectionType(Type type) {
        Class<?> elementClass;
        Optional<MetaElement> elementType;
        if (type instanceof Class && ((Class)type).isArray() && (elementType = this.allocateMetaElement(elementClass = ((Class)type).getComponentType())).isPresent()) {
            MetaArrayType arrayType = new MetaArrayType();
            arrayType.setName(elementType.get().getName() + "$array");
            arrayType.setId(elementType.get().getId() + "$array");
            arrayType.setImplementationType(type);
            arrayType.setElementType((MetaType)elementType.get());
            return this.addElement(type, arrayType);
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length == 1) {
            ParameterizedType paramType = (ParameterizedType)type;
            boolean isSet = Set.class.isAssignableFrom((Class)paramType.getRawType());
            boolean isList = List.class.isAssignableFrom((Class)paramType.getRawType());
            if (!isSet && !isList) {
                return Optional.empty();
            }
            Optional<MetaElement> elementType2 = this.allocateMetaElement(paramType.getActualTypeArguments()[0]);
            if (!elementType2.isPresent()) {
                return Optional.empty();
            }
            if (isSet) {
                MetaSetType metaSet = new MetaSetType();
                metaSet.setId(((MetaType)elementType2.get()).getId() + "$set");
                metaSet.setName(((MetaType)elementType2.get()).getName() + "$set");
                metaSet.setImplementationType(paramType);
                metaSet.setElementType((MetaType)elementType2.get());
                return this.addElement(type, metaSet);
            }
            PreconditionUtil.assertTrue((String)"expected a list type", (boolean)isList);
            MetaListType metaList = new MetaListType();
            metaList.setId(((MetaType)elementType2.get()).getId() + "list");
            metaList.setName(((MetaType)elementType2.get()).getName() + "$list");
            metaList.setImplementationType(paramType);
            metaList.setElementType((MetaType)elementType2.get());
            return this.addElement(type, metaList);
        }
        return Optional.empty();
    }

    private Optional<MetaElement> allocateMap(ParameterizedType paramType) {
        if (paramType.getRawType() instanceof Class && Map.class.isAssignableFrom((Class)paramType.getRawType())) {
            PreconditionUtil.assertEquals((String)"expected 2 type arguments", (Object)2, (Object)paramType.getActualTypeArguments().length);
            Optional<MetaElement> optKeyType = this.allocateMetaElement(paramType.getActualTypeArguments()[0]);
            Optional<MetaElement> optValueType = this.allocateMetaElement(paramType.getActualTypeArguments()[1]);
            if (optKeyType.isPresent() && optValueType.isPresent()) {
                MetaType keyType = (MetaType)optKeyType.get();
                MetaType valueType = (MetaType)optValueType.get();
                MetaMapType mapMeta = new MetaMapType();
                boolean primitiveKey = keyType instanceof MetaPrimitiveType;
                boolean primitiveValue = valueType instanceof MetaPrimitiveType;
                if (primitiveKey || !primitiveValue) {
                    mapMeta.setName(valueType.getName() + "$mappedBy$" + keyType.getName());
                    mapMeta.setId(valueType.getId() + "$mappedBy$" + keyType.getName());
                } else {
                    mapMeta.setName(keyType.getName() + "$map$" + valueType.getName());
                    mapMeta.setId(keyType.getId() + "$map$" + valueType.getName());
                }
                mapMeta.setImplementationType(paramType);
                mapMeta.setKeyType(keyType);
                mapMeta.setElementType(valueType);
                return this.addElement(paramType, mapMeta);
            }
        }
        return Optional.empty();
    }
}

