/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.provider.resource;

import io.crnk.meta.internal.MetaIdProvider;
import io.crnk.meta.internal.resource.ResourceMetaFilter;
import io.crnk.meta.internal.resource.ResourceMetaParitition;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.resource.MetaJsonObject;
import io.crnk.meta.model.resource.MetaResource;
import io.crnk.meta.model.resource.MetaResourceAction;
import io.crnk.meta.model.resource.MetaResourceBase;
import io.crnk.meta.model.resource.MetaResourceField;
import io.crnk.meta.model.resource.MetaResourceRepository;
import io.crnk.meta.provider.MetaFilter;
import io.crnk.meta.provider.MetaPartition;
import io.crnk.meta.provider.MetaProviderBase;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ResourceMetaProvider
extends MetaProviderBase {
    public static final String DEFAULT_ID_PREFIX = "resources";
    private final ResourceMetaParitition partition;
    private MetaIdProvider idProvider = new MetaIdProvider();

    public ResourceMetaProvider() {
        this("resources.");
    }

    public ResourceMetaProvider(String idPrefix) {
        this.partition = new ResourceMetaParitition(idPrefix, this.idProvider);
    }

    public void putIdMapping(String packageName, String idPrefix) {
        this.idProvider.putIdMapping(packageName, idPrefix);
    }

    @Override
    public Collection<MetaFilter> getFilters() {
        return Arrays.asList(new ResourceMetaFilter(this.partition, this.context));
    }

    @Override
    public Collection<MetaPartition> getPartitions() {
        return Arrays.asList(this.partition);
    }

    @Override
    public Set<Class<? extends MetaElement>> getMetaTypes() {
        return new HashSet<Class<? extends MetaElement>>(Arrays.asList(MetaResourceBase.class, MetaResource.class, MetaJsonObject.class, MetaResourceField.class, MetaResourceRepository.class, MetaResourceAction.class));
    }

    public <T extends MetaElement> T getMeta(Type type) {
        this.context.checkInitialized();
        return (T)this.partition.getMeta(type);
    }

    public <T extends MetaElement> T allocateMeta(Type type) {
        this.context.checkInitialized();
        return (T)this.partition.allocateMetaElement(type).get();
    }
}

