/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.module.Module;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.internal.BaseMetaPartition;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.provider.MetaFilter;
import io.crnk.meta.provider.MetaPartition;
import io.crnk.meta.provider.MetaPartitionContext;
import io.crnk.meta.provider.MetaProvider;
import io.crnk.meta.provider.MetaProviderContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaLookupImpl
implements MetaLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaLookupImpl.class);
    private LinkedList<MetaElement> initializationQueue = new LinkedList();
    private boolean discovering = false;
    private BaseMetaPartition basePartition;
    private boolean discovered;
    private Module.ModuleContext moduleContext;
    private List<MetaPartition> partitions = new ArrayList<MetaPartition>();
    private ConcurrentHashMap<String, MetaElement> idElementMap = new ConcurrentHashMap();
    private List<MetaFilter> filters = new CopyOnWriteArrayList<MetaFilter>();
    private List<MetaProvider> providers = new CopyOnWriteArrayList<MetaProvider>();
    private Set<Class<? extends MetaElement>> metaTypes = new HashSet<Class<? extends MetaElement>>();

    public MetaLookupImpl() {
        this.basePartition = new BaseMetaPartition();
        this.addPartition(this.basePartition);
    }

    public synchronized void addProvider(MetaProvider provider) {
        this.providers.add(provider);
        provider.init(new MetaProviderContext(){

            @Override
            public Module.ModuleContext getModuleContext() {
                return MetaLookupImpl.this.moduleContext;
            }

            @Override
            public Optional<MetaElement> getMetaElement(String id) {
                return Optional.ofNullable(MetaLookupImpl.this.idElementMap.get(id));
            }

            @Override
            public void checkInitialized() {
                MetaLookupImpl.this.checkInitialized();
            }

            @Override
            public <T> T runDiscovery(Callable<T> callable) {
                return (T)MetaLookupImpl.this.discover(callable);
            }
        });
        for (MetaFilter filter : provider.getFilters()) {
            this.addFilter(filter);
        }
        for (MetaPartition partition : provider.getPartitions()) {
            this.addPartition(partition);
        }
        this.metaTypes.addAll(provider.getMetaTypes());
    }

    private synchronized void addPartition(MetaPartition partition) {
        this.partitions.add(partition);
        partition.init(new MetaPartitionContext(){

            @Override
            public void addElement(MetaElement element) {
                MetaLookupImpl.this.add(element);
            }

            @Override
            public Module.ModuleContext getModuleContext() {
                return MetaLookupImpl.this.moduleContext;
            }

            @Override
            public Optional<MetaElement> getMetaElement(String id) {
                return Optional.ofNullable(MetaLookupImpl.this.idElementMap.get(id));
            }

            @Override
            public MetaPartition getBasePartition() {
                return MetaLookupImpl.this.basePartition;
            }

            @Override
            public <T> T runDiscovery(Callable<T> callable) {
                return (T)MetaLookupImpl.this.discover(callable);
            }
        });
    }

    private void addFilter(MetaFilter filter) {
        this.filters.add(filter);
    }

    public void setModuleContext(Module.ModuleContext moduleContext) {
        this.moduleContext = moduleContext;
    }

    public synchronized void registerPrimitiveType(Class<?> clazz) {
        this.basePartition.registerPrimitiveType(clazz);
    }

    public Map<String, MetaElement> getMetaById() {
        this.checkInitialized();
        return Collections.unmodifiableMap(this.idElementMap);
    }

    public synchronized void add(MetaElement element) {
        PreconditionUtil.verify((boolean)this.discovering, (String)"no discovering", (Object[])new Object[0]);
        PreconditionUtil.verify((element.getName() != null ? 1 : 0) != 0, (String)"no name provided for %s", (Object[])new Object[]{element});
        if (!element.hasId() && element.getParent() != null) {
            element.setId(element.getParent().getId() + "." + element.getName());
        }
        PreconditionUtil.verify((!this.idElementMap.contains(element.getId()) ? 1 : 0) != 0, (String)"element with id=%d already exists", (Object[])new Object[]{element.getId()});
        LOGGER.trace("trace {} of type {}", (Object)element.getId(), (Object)element.getClass().getSimpleName());
        this.initializationQueue.add(element);
        this.idElementMap.put(element.getId(), element);
        for (MetaElement child : element.getChildren()) {
            this.add(child);
        }
    }

    private synchronized void checkInitialized() {
        if (!this.discovered && !this.discovering) {
            this.initialize();
        }
    }

    public synchronized void initialize() {
        this.discover(() -> {
            if (!this.discovered) {
                for (MetaPartition provider : this.partitions) {
                    provider.discoverElements();
                }
                this.discovered = true;
            }
            return null;
        });
    }

    private synchronized <T> T discover(Callable<T> callable) {
        if (this.discovering) {
            try {
                return callable.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.debug("discovery failed", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        try {
            LOGGER.trace("discovery started");
            this.discovering = true;
            T result = callable.call();
            while (!this.initializationQueue.isEmpty()) {
                MetaElement element = this.initializationQueue.pollFirst();
                if (element.getParent() != null) continue;
                this.initialize(element);
            }
            LOGGER.trace("discovery completed");
            T t = result;
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.trace("discovery failed", (Throwable)e);
            throw new IllegalStateException(e);
        }
        finally {
            this.discovering = false;
        }
    }

    private void initialize(MetaElement element) {
        LOGGER.trace("discovering {}", (Object)element.getId());
        for (MetaFilter filter : this.filters) {
            filter.onInitializing(element);
        }
        for (MetaElement child : element.getChildren()) {
            this.initialize(child);
        }
        for (MetaFilter filter : this.filters) {
            filter.onInitialized(element);
        }
        LOGGER.trace("added {}", (Object)element.getId());
    }

    @Override
    public <T extends MetaElement> List<T> findElements(Class<T> metaType) {
        ArrayList<MetaElement> list = new ArrayList<MetaElement>();
        for (MetaElement element : this.idElementMap.values()) {
            if (!metaType.isInstance(element)) continue;
            list.add(element);
        }
        return list;
    }

    @Override
    public <T extends MetaElement> T findElement(Class<T> metaType, Class<?> implementationClass) {
        for (MetaPartition partition : this.partitions) {
            MetaElement element;
            if (!partition.hasMeta(implementationClass) || !metaType.isInstance(element = partition.getMeta(implementationClass))) continue;
            return (T)element;
        }
        return null;
    }

    @Override
    public <T extends MetaElement> T findElement(Class<T> metaType, String id) {
        return (T)this.idElementMap.get(id);
    }

    public void putElement(MetaElement element) {
        this.idElementMap.put(element.getId(), element);
    }

    protected Module.ModuleContext getContext() {
        return this.moduleContext;
    }

    public List<MetaFilter> getFilters() {
        return this.filters;
    }

    public <T extends MetaPartition> T getPartition(Class clazz) {
        for (MetaPartition partition : this.partitions) {
            if (!clazz.isInstance(partition)) continue;
            return (T)partition;
        }
        throw new IllegalStateException();
    }
}

