/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.information.InformationBuilder;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldInformationProvider;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationProvider;
import io.crnk.core.engine.information.resource.ResourceInformationProviderContext;
import io.crnk.core.engine.internal.information.DefaultInformationBuilder;
import io.crnk.core.engine.internal.information.resource.DefaultResourceFieldInformationProvider;
import io.crnk.core.engine.internal.information.resource.DefaultResourceInformationProvider;
import io.crnk.core.engine.internal.jackson.JacksonResourceFieldInformationProvider;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryPartAdapter;
import io.crnk.core.engine.registry.ResourceRegistryPartEvent;
import io.crnk.core.engine.registry.ResourceRegistryPartListener;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleExtensionAware;
import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.utils.Supplier;
import io.crnk.legacy.registry.DefaultResourceInformationProviderContext;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.MetaLookupImpl;
import io.crnk.meta.MetaModuleConfig;
import io.crnk.meta.MetaModuleExtension;
import io.crnk.meta.internal.MetaRelationshipRepositoryImpl;
import io.crnk.meta.internal.MetaResourceRepositoryImpl;
import io.crnk.meta.model.MetaArrayType;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaCollectionType;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaEnumType;
import io.crnk.meta.model.MetaInterface;
import io.crnk.meta.model.MetaKey;
import io.crnk.meta.model.MetaListType;
import io.crnk.meta.model.MetaLiteral;
import io.crnk.meta.model.MetaMapType;
import io.crnk.meta.model.MetaPrimaryKey;
import io.crnk.meta.model.MetaPrimitiveType;
import io.crnk.meta.model.MetaSetType;
import io.crnk.meta.model.MetaType;
import io.crnk.meta.provider.MetaProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MetaModule
implements ModuleExtensionAware<MetaModuleExtension> {
    private MetaLookupImpl currentLookup;
    private ThreadLocal<MetaLookup> lookupRequestLocal = new ThreadLocal();
    private Module.ModuleContext context;
    private MetaModuleConfig config;
    private DefaultResourceInformationProvider informationBuilder;

    protected MetaModule() {
        this(new MetaModuleConfig());
    }

    private MetaModule(MetaModuleConfig config) {
        this.config = config;
    }

    public static MetaModule createClientModule() {
        return new MetaModule(new MetaModuleConfig());
    }

    public static MetaModule createServerModule(MetaModuleConfig config) {
        return new MetaModule(config);
    }

    public String getModuleName() {
        return "meta";
    }

    public void setupModule(Module.ModuleContext context) {
        this.context = context;
        this.informationBuilder = this.registerInformationBuilder(context.getPropertiesProvider());
        if (context.isServer()) {
            context.addFilter((filterRequestContext, chain) -> {
                try {
                    Response response = chain.doFilter(filterRequestContext);
                    return response;
                }
                finally {
                    this.lookupRequestLocal.remove();
                }
            });
        } else {
            context.addResourceLookup(new ResourceLookup(){

                public Set<Class<?>> getResourceClasses() {
                    return MetaModule.this.collectMetaClasses();
                }
            });
        }
    }

    private void initRefreshListener() {
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        resourceRegistry.addListener((ResourceRegistryPartListener)new ResourceRegistryPartAdapter(){

            public void onChanged(ResourceRegistryPartEvent event) {
                MetaModule.this.currentLookup = null;
            }
        });
    }

    protected DefaultResourceInformationProvider registerInformationBuilder(PropertiesProvider propertiesProvider) {
        DefaultInformationBuilder informationBuilder = new DefaultInformationBuilder(this.context.getTypeParser());
        DefaultResourceInformationProvider informationProvider = new DefaultResourceInformationProvider(propertiesProvider, (PagingBehavior)new OffsetLimitPagingBehavior(), new ResourceFieldInformationProvider[]{new DefaultResourceFieldInformationProvider(), new JacksonResourceFieldInformationProvider()});
        informationProvider.init((ResourceInformationProviderContext)new DefaultResourceInformationProviderContext((ResourceInformationProvider)informationProvider, (InformationBuilder)informationBuilder, this.context.getTypeParser(), () -> this.context.getObjectMapper()){

            public ObjectMapper getObjectMapper() {
                return MetaModule.this.context.getObjectMapper();
            }
        });
        return informationProvider;
    }

    protected void registerRepositories(DefaultResourceInformationProvider informationBuilder, Set<Class<? extends MetaElement>> metaClasses) {
        Supplier<MetaLookup> lookupSupplier = new Supplier<MetaLookup>(){

            public MetaLookup get() {
                return MetaModule.this.getLookup();
            }
        };
        for (Class<? extends MetaElement> metaClass : metaClasses) {
            this.context.addRepository(new MetaResourceRepositoryImpl<MetaElement>(lookupSupplier, metaClass));
            HashSet<Class> targetResourceClasses = new HashSet<Class>();
            ResourceInformation information = informationBuilder.build(metaClass);
            for (ResourceField relationshipField : information.getRelationshipFields()) {
                if (!MetaElement.class.isAssignableFrom(relationshipField.getElementType())) {
                    throw new IllegalStateException("only MetaElement relations supported, got " + relationshipField);
                }
                targetResourceClasses.add(relationshipField.getElementType());
            }
            for (Class targetResourceClass : targetResourceClasses) {
                this.context.addRepository((Object)new MetaRelationshipRepositoryImpl(lookupSupplier, metaClass, targetResourceClass));
            }
        }
    }

    protected Set<Class<? extends MetaElement>> collectMetaClasses() {
        HashSet<Class<? extends MetaElement>> metaClasses = new HashSet<Class<? extends MetaElement>>();
        metaClasses.add(MetaArrayType.class);
        metaClasses.add(MetaAttribute.class);
        metaClasses.add(MetaCollectionType.class);
        metaClasses.add(MetaDataObject.class);
        metaClasses.add(MetaElement.class);
        metaClasses.add(MetaEnumType.class);
        metaClasses.add(MetaInterface.class);
        metaClasses.add(MetaKey.class);
        metaClasses.add(MetaListType.class);
        metaClasses.add(MetaLiteral.class);
        metaClasses.add(MetaMapType.class);
        metaClasses.add(MetaPrimaryKey.class);
        metaClasses.add(MetaPrimitiveType.class);
        metaClasses.add(MetaSetType.class);
        metaClasses.add(MetaType.class);
        this.collectMetaClasses(metaClasses, this.config.getProviders());
        return metaClasses;
    }

    private void collectMetaClasses(Set<Class<? extends MetaElement>> metaClasses, Collection<MetaProvider> providers) {
        for (MetaProvider provider : providers) {
            metaClasses.addAll(provider.getMetaTypes());
            this.collectMetaClasses(metaClasses, provider.getDependencies());
        }
    }

    public void setExtensions(List<MetaModuleExtension> extensions) {
        for (MetaModuleExtension extension : extensions) {
            for (MetaProvider provider : extension.getProviders()) {
                this.config.addMetaProvider(provider);
            }
        }
    }

    public void init() {
        Set<Class<? extends MetaElement>> metaClasses = this.collectMetaClasses();
        if (this.context.isServer()) {
            this.initRefreshListener();
            this.registerRepositories(this.informationBuilder, metaClasses);
        }
    }

    public synchronized MetaLookup getLookup() {
        MetaLookupImpl requestLookup;
        if (this.currentLookup == null) {
            this.initLookup();
        }
        if ((requestLookup = (MetaLookupImpl)this.lookupRequestLocal.get()) == null) {
            requestLookup = this.currentLookup;
            this.lookupRequestLocal.set(requestLookup);
        }
        return requestLookup;
    }

    private void initLookup() {
        MetaLookupImpl lookup = new MetaLookupImpl();
        this.config.apply(lookup);
        lookup.setModuleContext(this.context);
        lookup.initialize();
        this.currentLookup = lookup;
    }

    protected ThreadLocal<MetaLookup> getLookupRequestLocal() {
        return this.lookupRequestLocal;
    }

    protected void reset() {
        this.currentLookup = null;
    }
}

