/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.SerializeType;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

@JsonApiResource(type="metaAttribute", resourcePath="meta/attribute")
public class MetaAttribute
extends MetaElement {
    @JsonApiRelation(serialize=SerializeType.LAZY, lookUp=LookupIncludeBehavior.AUTOMATICALLY_ALWAYS)
    private MetaType type;
    private boolean association;
    @JsonIgnore
    private Method readMethod;
    @JsonIgnore
    private Method writeMethod;
    @JsonIgnore
    private Field field;
    private String underlyingName;
    private boolean derived;
    private boolean lazy;
    private boolean version;
    private boolean primaryKeyAttribute;
    private boolean sortable;
    private boolean filterable;
    private boolean insertable;
    private boolean updatable;
    private boolean lob;
    private boolean nullable;
    private boolean cascaded;
    private boolean readable;
    private boolean owner;
    @JsonApiRelation(serialize=SerializeType.LAZY)
    private MetaAttribute oppositeAttribute;

    private void initAccessors() {
        if (this.field == null || this.readMethod == null) {
            MetaDataObject parent = this.getParent();
            Class<?> beanClass = parent.getImplementationClass();
            String name = this.getUnderlyingName() == null ? this.getName() : this.getUnderlyingName();
            this.field = ClassUtils.findClassField(beanClass, (String)name);
            this.readMethod = ClassUtils.findGetter(beanClass, (String)name);
            if (this.field != null || this.readMethod != null) {
                Class<?> rawType = this.field != null ? this.field.getType() : this.readMethod.getReturnType();
                this.writeMethod = ClassUtils.findSetter(beanClass, (String)name, rawType);
            }
        }
    }

    public boolean isCascaded() {
        return this.cascaded;
    }

    public void setCascaded(boolean cascade) {
        this.cascaded = cascade;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public Method getWriteMethod() {
        this.initAccessors();
        return this.writeMethod;
    }

    public void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
    }

    public Method getReadMethod() {
        this.initAccessors();
        PreconditionUtil.assertNotNull((String)"no getter available", (Object)this.readMethod);
        return this.readMethod;
    }

    public void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
    }

    @Override
    public MetaDataObject getParent() {
        return (MetaDataObject)super.getParent();
    }

    public boolean isAssociation() {
        return this.association;
    }

    public void setAssociation(boolean association) {
        this.association = association;
    }

    public MetaType getType() {
        return this.type;
    }

    public void setType(MetaType type) {
        this.type = type;
    }

    public Object getValue(Object dataObject) {
        return PropertyUtils.getProperty((Object)dataObject, (String)this.getName());
    }

    public void setValue(Object dataObject, Object value) {
        PropertyUtils.setProperty((Object)dataObject, (String)this.getName(), (Object)value);
    }

    public MetaAttribute getOppositeAttribute() {
        return this.oppositeAttribute;
    }

    public void setOppositeAttribute(MetaAttribute oppositeAttribue) {
        this.oppositeAttribute = oppositeAttribue;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public void addValue(Object dataObject, Object value) {
        Collection col = (Collection)this.getValue(dataObject);
        col.add(value);
    }

    public void removeValue(Object dataObject, Object value) {
        Collection col = (Collection)this.getValue(dataObject);
        col.remove(value);
    }

    @JsonIgnore
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        this.initAccessors();
        T annotation = null;
        if (this.field != null) {
            annotation = this.field.getAnnotation(clazz);
        }
        if (annotation == null && this.readMethod != null) {
            annotation = this.readMethod.getAnnotation(clazz);
        }
        if (annotation == null && this.writeMethod != null) {
            annotation = this.writeMethod.getAnnotation(clazz);
        }
        return annotation;
    }

    @JsonIgnore
    public Collection<Annotation> getAnnotations() {
        this.initAccessors();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (this.field != null) {
            annotations.addAll(Arrays.asList(this.field.getAnnotations()));
        }
        if (this.readMethod != null) {
            annotations.addAll(Arrays.asList(this.readMethod.getAnnotations()));
        }
        if (this.writeMethod != null) {
            annotations.addAll(Arrays.asList(this.writeMethod.getAnnotations()));
        }
        return annotations;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public void setOwner(boolean owner) {
        this.owner = owner;
    }

    public boolean isPrimaryKeyAttribute() {
        return this.primaryKeyAttribute;
    }

    public void setPrimaryKeyAttribute(boolean primaryKeyAttribute) {
        this.primaryKeyAttribute = primaryKeyAttribute;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public boolean isLob() {
        return this.lob;
    }

    public void setLob(boolean blob) {
        this.lob = blob;
    }

    public String getUnderlyingName() {
        return this.underlyingName;
    }

    public void setUnderlyingName(String underlyingName) {
        this.underlyingName = underlyingName;
    }
}

