/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.SerializeType;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaAttributeFinder;
import io.crnk.meta.model.MetaAttributePath;
import io.crnk.meta.model.MetaCollectionType;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaInterface;
import io.crnk.meta.model.MetaKey;
import io.crnk.meta.model.MetaMapAttribute;
import io.crnk.meta.model.MetaMapType;
import io.crnk.meta.model.MetaPrimaryKey;
import io.crnk.meta.model.MetaType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonApiResource(type="metaDataObject", resourcePath="meta/dataObject")
public abstract class MetaDataObject
extends MetaType {
    private static final MetaAttributeFinder DEFAULT_ATTRIBUTE_FINDER = new MetaAttributeFinder(){

        @Override
        public MetaAttribute getAttribute(MetaDataObject meta, String name) {
            return meta.getAttribute(name);
        }
    };
    private static final MetaAttributeFinder SUBTYPE_ATTRIBUTE_FINDER = new MetaAttributeFinder(){

        @Override
        public MetaAttribute getAttribute(MetaDataObject meta, String name) {
            return meta.findAttribute(name, true);
        }
    };
    @JsonApiRelation(opposite="superType", lookUp=LookupIncludeBehavior.AUTOMATICALLY_ALWAYS)
    private Set<MetaDataObject> subTypes = new HashSet<MetaDataObject>();
    @JsonApiRelation(serialize=SerializeType.LAZY, opposite="subTypes", lookUp=LookupIncludeBehavior.AUTOMATICALLY_ALWAYS)
    private MetaDataObject superType;
    @JsonIgnore
    private Map<String, MetaAttribute> attrMap = null;
    @JsonApiRelation(lookUp=LookupIncludeBehavior.AUTOMATICALLY_ALWAYS)
    private List<MetaAttribute> attributes = null;
    @JsonApiRelation(lookUp=LookupIncludeBehavior.AUTOMATICALLY_ALWAYS)
    private List<MetaAttribute> declaredAttributes = null;
    @JsonIgnore
    private List<MetaDataObject>[] subTypesCache = new List[4];
    @JsonApiRelation(serialize=SerializeType.LAZY, lookUp=LookupIncludeBehavior.AUTOMATICALLY_ALWAYS)
    private MetaPrimaryKey primaryKey;
    @JsonApiRelation(lookUp=LookupIncludeBehavior.AUTOMATICALLY_ALWAYS)
    private Set<MetaKey> declaredKeys = new HashSet<MetaKey>();
    @JsonApiRelation(lookUp=LookupIncludeBehavior.AUTOMATICALLY_ALWAYS)
    private Set<MetaInterface> interfaces = new HashSet<MetaInterface>();
    private boolean insertable = true;
    private boolean updatable = true;
    private boolean deletable = true;
    private boolean readable = true;

    @JsonIgnore
    public MetaAttribute getVersionAttribute() {
        for (MetaAttribute metaAttribute : this.getAttributes()) {
            if (!metaAttribute.isVersion()) continue;
            return metaAttribute;
        }
        return null;
    }

    private void clearSubtypeCache() {
        this.subTypesCache = new List[4];
    }

    public List<? extends MetaAttribute> getAttributes() {
        if (this.attributes == null) {
            this.setupCache();
        }
        return this.attributes;
    }

    public void setAttributes(List<MetaAttribute> attributes) {
        this.attributes = attributes;
    }

    public List<? extends MetaAttribute> getDeclaredAttributes() {
        if (this.declaredAttributes == null) {
            this.setupCache();
        }
        return this.declaredAttributes;
    }

    public void setDeclaredAttributes(List<MetaAttribute> declaredAttributes) {
        this.declaredAttributes = declaredAttributes;
    }

    public MetaAttribute getAttribute(String name) {
        this.setupCache();
        MetaAttribute attr = this.attrMap.get(name);
        PreconditionUtil.assertNotNull((String)(this.getName() + "." + name), (Object)attr);
        return attr;
    }

    public MetaAttributePath resolvePath(List<String> attrPath, boolean includeSubTypes) {
        MetaAttributeFinder finder = includeSubTypes ? SUBTYPE_ATTRIBUTE_FINDER : DEFAULT_ATTRIBUTE_FINDER;
        return this.resolvePath(attrPath, finder);
    }

    public MetaAttributePath resolvePath(List<String> attrPath) {
        return this.resolvePath(attrPath, true);
    }

    public MetaAttributePath resolvePath(List<String> attrPath, MetaAttributeFinder finder) {
        this.setupCache();
        if (attrPath == null) {
            throw new IllegalArgumentException("attribute path must not be null");
        }
        LinkedList<MetaAttribute> list = new LinkedList<MetaAttribute>();
        MetaDataObject currentMdo = this;
        for (int i = 0; i < attrPath.size(); ++i) {
            String pathElementName = attrPath.get(i);
            MetaAttribute pathElement = finder.getAttribute(currentMdo, pathElementName);
            if (i < attrPath.size() - 1 && pathElement.getType() instanceof MetaMapType) {
                MetaMapType mapType = (MetaMapType)pathElement.getType();
                String keyString = attrPath.get(i + 1);
                MetaMapAttribute keyAttr = new MetaMapAttribute(mapType, pathElement, keyString);
                list.add(keyAttr);
                MetaType valueType = mapType.getElementType();
                currentMdo = this.nextPathElement(valueType, ++i, attrPath);
                continue;
            }
            list.add(pathElement);
            currentMdo = this.nextPathElement(pathElement.getType(), i, attrPath);
        }
        return new MetaAttributePath(list);
    }

    private MetaDataObject nextPathElement(MetaType pathElementType, int i, List<String> pathElements) {
        if (i == pathElements.size() - 1) {
            return null;
        }
        if (pathElementType instanceof MetaCollectionType) {
            pathElementType = pathElementType.getElementType();
        }
        if (!(pathElementType instanceof MetaDataObject)) {
            throw new IllegalArgumentException("failed to resolve path " + pathElements + ", expected a simple object, but got " + pathElementType.getImplementationClass());
        }
        return pathElementType.asDataObject();
    }

    public MetaAttribute findAttribute(String name, boolean includeSubTypes) {
        if (this.hasAttribute(name)) {
            return this.getAttribute(name);
        }
        if (includeSubTypes) {
            List<MetaDataObject> transitiveSubTypes = this.getSubTypes(true, true);
            for (MetaDataObject subType : transitiveSubTypes) {
                if (!subType.hasAttribute(name)) continue;
                return subType.getAttribute(name);
            }
        }
        throw new IllegalStateException("attribute " + name + " not found in " + this.getName());
    }

    public boolean hasAttribute(String name) {
        if (this.attrMap == null) {
            this.setupCache();
        }
        return this.attrMap.containsKey(name);
    }

    public MetaDataObject getSuperType() {
        return this.superType;
    }

    public void setSuperType(MetaDataObject superType) {
        this.superType = superType;
    }

    public List<MetaDataObject> getSubTypes(boolean transitive, boolean self) {
        int cacheIndex = (transitive ? 2 : 0) | (self ? 1 : 0);
        List<MetaDataObject> cached = this.subTypesCache[cacheIndex];
        if (cached != null) {
            return cached;
        }
        ArrayList<MetaDataObject> types = this.computeSubTypes(transitive, self);
        List<MetaDataObject> unmodifiableList = Collections.unmodifiableList(types);
        this.subTypesCache[cacheIndex] = unmodifiableList;
        return unmodifiableList;
    }

    private ArrayList<MetaDataObject> computeSubTypes(boolean transitive, boolean self) {
        ArrayList<MetaDataObject> types = new ArrayList<MetaDataObject>();
        if (!(!self || this.isAbstract() && this.subTypes.isEmpty())) {
            types.add(this);
        }
        for (MetaDataObject subType : this.subTypes) {
            if (!subType.isAbstract() || !subType.getSubTypes().isEmpty()) {
                types.add(subType);
            }
            if (!transitive) continue;
            types.addAll(subType.getSubTypes(true, false));
        }
        return types;
    }

    @JsonIgnore
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getImplementationClass().getModifiers());
    }

    public Set<MetaDataObject> getSubTypes() {
        return this.subTypes;
    }

    public void setSubTypes(Set<MetaDataObject> subTypes) {
        this.subTypes = subTypes;
    }

    public Set<MetaInterface> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Set<MetaInterface> interfaces) {
        this.interfaces = interfaces;
    }

    public MetaPrimaryKey getPrimaryKey() {
        if (this.primaryKey == null && this.superType != null) {
            return this.superType.getPrimaryKey();
        }
        return this.primaryKey;
    }

    public void setPrimaryKey(MetaPrimaryKey key) {
        this.primaryKey = key;
        this.addDeclaredKey(key);
    }

    public Set<MetaKey> getDeclaredKeys() {
        return this.declaredKeys;
    }

    public void setDeclaredKeys(Set<MetaKey> declaredKeys) {
        this.declaredKeys = declaredKeys;
    }

    public void addDeclaredKey(MetaKey key) {
        this.declaredKeys.add(key);
    }

    public void addSubType(MetaDataObject subType) {
        this.subTypes.add(subType);
        this.clearSubtypeCache();
    }

    private void setupCache() {
        if (this.declaredAttributes == null) {
            ArrayList<MetaAttribute> newDeclaredAttributes = new ArrayList<MetaAttribute>();
            ArrayList<? extends MetaAttribute> newAttributes = new ArrayList<MetaAttribute>();
            if (this.superType != null) {
                newAttributes.addAll(this.superType.getAttributes());
            }
            for (MetaElement child : this.getChildren()) {
                if (!(child instanceof MetaAttribute)) continue;
                MetaAttribute attr = (MetaAttribute)child;
                newDeclaredAttributes.add(attr);
                newAttributes.add(attr);
                if (this.superType == null || !this.superType.hasAttribute(attr.getName())) continue;
                MetaAttribute superAttr = this.superType.getAttribute(attr.getName());
                boolean remove = newAttributes.remove(superAttr);
                PreconditionUtil.verify((boolean)remove, (String)"expected overriden element to be removed", (Object[])new Object[0]);
            }
            this.attributes = Collections.unmodifiableList(newAttributes);
            this.declaredAttributes = Collections.unmodifiableList(newDeclaredAttributes);
        }
        if (this.attrMap == null) {
            HashMap<String, MetaAttribute> newAttrMap = new HashMap<String, MetaAttribute>();
            if (this.superType != null) {
                this.superType.setupCache();
                newAttrMap.putAll(this.superType.attrMap);
            }
            for (MetaAttribute attr : this.declaredAttributes) {
                newAttrMap.put(attr.getName(), attr);
            }
            this.attrMap = Collections.unmodifiableMap(newAttrMap);
        }
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }
}

