/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.rs.internal.legacy;

import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.rs.internal.legacy.RequestContextParameterProviderRegistry;
import io.crnk.rs.internal.legacy.provider.ContainerRequestContextProvider;
import io.crnk.rs.internal.legacy.provider.CookieParamProvider;
import io.crnk.rs.internal.legacy.provider.HeaderParamProvider;
import io.crnk.rs.internal.legacy.provider.QueryParamProvider;
import io.crnk.rs.internal.legacy.provider.RequestContextParameterProvider;
import io.crnk.rs.internal.legacy.provider.SecurityContextProvider;
import java.util.HashSet;
import java.util.Set;

public class RequestContextParameterProviderRegistryBuilder {
    private Set<RequestContextParameterProvider> providers = new HashSet<RequestContextParameterProvider>();

    public RequestContextParameterProviderRegistry build(ServiceDiscovery discovery) {
        this.addDefaultProviders();
        for (RequestContextParameterProvider parameterProvider : discovery.getInstancesByType(RequestContextParameterProvider.class)) {
            this.registerRequestContextProvider(parameterProvider);
        }
        return new RequestContextParameterProviderRegistry(this.providers);
    }

    private void addDefaultProviders() {
        this.registerRequestContextProvider(new ContainerRequestContextProvider());
        this.registerRequestContextProvider(new SecurityContextProvider());
        this.registerRequestContextProvider(new CookieParamProvider());
        this.registerRequestContextProvider(new HeaderParamProvider());
        this.registerRequestContextProvider(new QueryParamProvider());
    }

    private void registerRequestContextProvider(RequestContextParameterProvider requestContextParameterProvider) {
        this.providers.add(requestContextParameterProvider);
    }
}

