/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.rs;

import io.crnk.core.engine.http.HttpRequestContextBase;
import io.crnk.core.engine.internal.http.HttpRequestDispatcherImpl;
import io.crnk.rs.CrnkFeature;
import io.crnk.rs.JaxrsRequestContext;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Priority(value=0x7FFFFFFF)
public class CrnkFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrnkFilter.class);
    private final CrnkFeature feature;

    public CrnkFilter(CrnkFeature feature) {
        this.feature = feature;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            LOGGER.debug("CrnkFilter entered");
            JaxrsRequestContext context = new JaxrsRequestContext(requestContext, this.feature);
            HttpRequestDispatcherImpl requestDispatcher = this.feature.getBoot().getRequestDispatcher();
            requestDispatcher.process((HttpRequestContextBase)context);
            context.checkAbort();
            LOGGER.debug("CrnkFilter exited");
        }
        catch (WebApplicationException e) {
            LOGGER.error("failed to dispatch request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("failed to dispatch request", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }
}

