/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.rs;

import io.crnk.core.boot.CrnkBoot;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextBase;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.http.HttpRequestContextBaseAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.ResourceListBase;
import io.crnk.core.utils.Nullable;
import io.crnk.rs.CrnkFeature;
import io.crnk.rs.JaxrsRequestContext;
import io.crnk.rs.type.JsonApiMediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

public class JsonApiResponseFilter
implements ContainerResponseFilter {
    private CrnkFeature feature;
    @Context
    private ResourceInfo resourceInfo;

    public JsonApiResponseFilter(CrnkFeature feature) {
        this.feature = feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object response = responseContext.getEntity();
        if (response == null) {
            if (this.feature.getBoot().isNullDataResponseEnabled()) {
                Document document = new Document();
                document.setData(Nullable.nullValue());
                responseContext.setEntity((Object)document);
                responseContext.setStatus(Response.Status.OK.getStatusCode());
                responseContext.getHeaders().put((Object)"Content-Type", Collections.singletonList("application/vnd.api+json"));
            }
            return;
        }
        if (this.isResourceResponse(response)) {
            CrnkBoot boot = this.feature.getBoot();
            DocumentMapper documentMapper = boot.getDocumentMapper();
            HttpRequestContextProvider httpRequestContextProvider = boot.getModuleRegistry().getHttpRequestContextProvider();
            try {
                HttpRequestContextBaseAdapter context = new HttpRequestContextBaseAdapter((HttpRequestContextBase)new JaxrsRequestContext(requestContext, this.feature));
                httpRequestContextProvider.onRequestStarted((HttpRequestContext)context);
                JsonApiResponse jsonApiResponse = new JsonApiResponse();
                jsonApiResponse.setEntity(response);
                DocumentMappingConfig mappingConfig = new DocumentMappingConfig();
                QuerySpecAdapter queryAdapter = new QuerySpecAdapter(null, null, context.getQueryContext());
                responseContext.setEntity(documentMapper.toDocument(jsonApiResponse, (QueryAdapter)queryAdapter, mappingConfig).get());
                responseContext.getHeaders().put((Object)"Content-Type", Collections.singletonList("application/vnd.api+json"));
            }
            finally {
                httpRequestContextProvider.onRequestFinished();
            }
        } else if (this.isJsonApiResponse(responseContext) && !this.doNotWrap(response)) {
            Document document = new Document();
            document.setData(Nullable.of((Object)response));
            responseContext.setEntity((Object)document);
        }
    }

    private boolean isResourceResponse(Object response) {
        boolean singleResource = this.feature.getBoot().getResourceRegistry().hasEntry(response.getClass());
        boolean resourceList = ResourceListBase.class.isAssignableFrom(response.getClass());
        return singleResource || resourceList;
    }

    private boolean isJsonApiResponse(ContainerResponseContext responseContext) {
        return JsonApiMediaType.APPLICATION_JSON_API_TYPE.equals((Object)responseContext.getMediaType());
    }

    private boolean doNotWrap(Object entity) {
        return entity instanceof Document || entity instanceof InputStream;
    }
}

