/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.rs;

import io.crnk.core.boot.CrnkBoot;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.exception.InternalServerErrorException;
import io.crnk.rs.CrnkFeature;
import java.util.ArrayList;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonapiExceptionMapperBridge
implements javax.ws.rs.ext.ExceptionMapper<RuntimeException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonapiExceptionMapperBridge.class);
    private CrnkFeature feature;

    public JsonapiExceptionMapperBridge(CrnkFeature feature) {
        this.feature = feature;
    }

    public Response toResponse(RuntimeException exception) {
        CrnkBoot boot = this.feature.getBoot();
        ExceptionMapperRegistry exceptionMapperRegistry = boot.getExceptionMapperRegistry();
        Optional optional = exceptionMapperRegistry.findMapperFor(exception.getClass());
        if (!optional.isPresent()) {
            LOGGER.error("no exception mapper found", (Throwable)exception);
            exception = new InternalServerErrorException(exception.getMessage());
            optional = exceptionMapperRegistry.findMapperFor(exception.getClass());
        }
        ExceptionMapper exceptionMapper = (ExceptionMapper)optional.get();
        ErrorResponse errorResponse = exceptionMapper.toErrorResponse((Throwable)exception);
        Document doc = new Document();
        ArrayList<ErrorData> errors = new ArrayList<ErrorData>();
        for (ErrorData error : errorResponse.getErrors()) {
            errors.add(error);
        }
        doc.setErrors(errors);
        return Response.status((int)errorResponse.getHttpStatus()).entity((Object)doc).header("Content-Type", (Object)"application/vnd.api+json").build();
    }
}

