/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.rs;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.boot.CrnkBoot;
import io.crnk.core.engine.information.repository.RepositoryInformationProvider;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.module.Module;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.rs.CrnkFilter;
import io.crnk.rs.internal.JaxrsModule;
import java.util.Collection;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConstrainedTo(value=RuntimeType.SERVER)
public class CrnkFeature
implements Feature {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrnkFeature.class);
    private CrnkBoot boot = new CrnkBoot();
    @Context
    protected SecurityContext securityContext;
    private boolean securityEnabled = true;

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.boot.setServiceUrlProvider(serviceUrlProvider);
    }

    public void addModule(Module module) {
        this.boot.addModule(module);
    }

    public boolean configure(FeatureContext context) {
        LOGGER.debug("configuring CrnkFeature");
        this.boot.setPropertiesProvider(this.createPropertiesProvider(context));
        this.boot.getCoreModule().setDefaultRepositoryInformationProvider((RepositoryInformationProvider)new JaxrsModule.JaxrsResourceRepositoryInformationProvider());
        this.boot.addModule((Module)new JaxrsModule(this.securityEnabled ? this.securityContext : null));
        this.boot.boot();
        CrnkFilter crnkFilter = this.createCrnkFilter();
        context.register((Object)crnkFilter);
        this.registerActionRepositories(context, this.boot);
        LOGGER.debug("configured CrnkFeature");
        return true;
    }

    protected PropertiesProvider createPropertiesProvider(FeatureContext context) {
        return key -> (String)context.getConfiguration().getProperty(key);
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    private void registerActionRepositories(FeatureContext context, CrnkBoot boot) {
        ResourceRegistry resourceRegistry = boot.getResourceRegistry();
        Collection registryEntries = resourceRegistry.getEntries();
        for (RegistryEntry registryEntry : registryEntries) {
            ResourceRepositoryInformation repositoryInformation = registryEntry.getRepositoryInformation();
            if (repositoryInformation == null || repositoryInformation.getActions().isEmpty()) continue;
            ResourceRepositoryAdapter repositoryAdapter = registryEntry.getResourceRepository();
            Object resourceRepository = repositoryAdapter.getImplementation();
            context.register(resourceRepository);
        }
    }

    protected CrnkFilter createCrnkFilter() {
        return new CrnkFilter(this);
    }

    public ObjectMapper getObjectMapper() {
        return this.boot.getObjectMapper();
    }

    public void setDefaultPageLimit(Long defaultPageLimit) {
        this.boot.setDefaultPageLimit(defaultPageLimit);
    }

    public QuerySpecUrlMapper getUrlMapper() {
        return this.boot.getUrlMapper();
    }

    public CrnkBoot getBoot() {
        return this.boot;
    }

    public String getWebPathPrefix() {
        return UrlUtils.removeLeadingSlash((String)this.boot.getWebPathPrefix());
    }
}

