/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.rs;

import io.crnk.core.engine.http.DefaultHttpRequestContextBase;
import io.crnk.core.engine.http.HttpResponse;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.core.utils.Nullable;
import io.crnk.rs.CrnkFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public class JaxrsRequestContext
extends DefaultHttpRequestContextBase {
    private final CrnkFeature feature;
    private ContainerRequestContext requestContext;
    private String path;
    private Map<String, Set<String>> parameters;
    private Nullable<byte[]> requestBody = Nullable.empty();
    private HttpResponse response = new HttpResponse();

    JaxrsRequestContext(ContainerRequestContext requestContext, CrnkFeature feature) {
        this.feature = feature;
        this.requestContext = requestContext;
        UriInfo uriInfo = requestContext.getUriInfo();
        this.path = this.buildPath(uriInfo);
        this.parameters = this.getParameters(uriInfo);
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public Set<String> getRequestHeaderNames() {
        return this.requestContext.getHeaders().keySet();
    }

    public String getRequestHeader(String name) {
        return this.requestContext.getHeaderString(name);
    }

    public Map<String, Set<String>> getRequestParameters() {
        return this.parameters;
    }

    public String getPath() {
        return this.path;
    }

    public String getBaseUrl() {
        String baseUrl = this.requestContext.getUriInfo().getBaseUri().toString();
        if (this.feature.getWebPathPrefix() == null) {
            return UrlUtils.removeTrailingSlash((String)baseUrl);
        }
        return UrlUtils.concat((String)baseUrl, (String[])new String[]{this.feature.getWebPathPrefix()});
    }

    public byte[] getRequestBody() {
        if (!this.requestBody.isPresent()) {
            try {
                int nRead;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[16384];
                InputStream is = this.requestContext.getEntityStream();
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                this.requestBody = Nullable.of((Object)buffer.toByteArray());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return (byte[])this.requestBody.get();
    }

    public String getMethod() {
        return this.requestContext.getMethod();
    }

    public URI getNativeRequestUri() {
        return this.requestContext.getUriInfo().getRequestUri();
    }

    public void checkAbort() {
        if (this.response != null && this.response.getStatusCode() != 0) {
            Response.ResponseBuilder builder = Response.status((int)this.response.getStatusCode());
            if (this.response.getBody() != null) {
                builder = builder.entity((Object)new ByteArrayInputStream(this.response.getBody()));
            }
            for (Map.Entry entry : this.response.getHeaders().entrySet()) {
                builder.header((String)entry.getKey(), entry.getValue());
            }
            this.requestContext.abortWith(builder.build());
        }
    }

    private Map<String, Set<String>> getParameters(UriInfo uriInfo) {
        MultivaluedMap queryParametersMultiMap = uriInfo.getQueryParameters();
        HashMap<String, Set<String>> queryParameters = new HashMap<String, Set<String>>();
        for (Map.Entry queryEntry : queryParametersMultiMap.entrySet()) {
            queryParameters.put((String)queryEntry.getKey(), new LinkedHashSet((Collection)queryEntry.getValue()));
        }
        return queryParameters;
    }

    private String buildPath(UriInfo uriInfo) {
        String basePath = UrlUtils.removeLeadingSlash((String)uriInfo.getPath());
        String webPathPrefix = this.feature.getWebPathPrefix();
        String path = webPathPrefix != null && basePath.startsWith(webPathPrefix) ? basePath.substring(webPathPrefix.length()) : basePath;
        return path == null || path.isEmpty() ? "/" : path;
    }
}

