/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.rs;

import io.crnk.core.boot.CrnkBoot;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextBase;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.http.HttpRequestContextBaseAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.queryspec.mapper.QueryParameterType;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.utils.Nullable;
import io.crnk.rs.CrnkFeature;
import io.crnk.rs.JaxrsRequestContext;
import io.crnk.rs.type.JsonApiMediaType;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

public class JsonApiResponseFilter
implements ContainerResponseFilter {
    private CrnkFeature feature;
    @Context
    private ResourceInfo resourceInfo;

    public JsonApiResponseFilter(CrnkFeature feature) {
        this.feature = feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Object response = responseContext.getEntity();
        if (response == null) {
            if (this.feature.getBoot().isNullDataResponseEnabled()) {
                Document document = new Document();
                document.setData(Nullable.nullValue());
                responseContext.setEntity((Object)document);
                responseContext.setStatus(Response.Status.OK.getStatusCode());
                responseContext.getHeaders().put((Object)"Content-Type", Collections.singletonList("application/vnd.api+json"));
            }
            return;
        }
        Optional<RegistryEntry> registryEntry = this.getRegistryEntry(response);
        if (registryEntry.isPresent()) {
            CrnkBoot boot = this.feature.getBoot();
            DocumentMapper documentMapper = boot.getDocumentMapper();
            HttpRequestContextProvider httpRequestContextProvider = boot.getModuleRegistry().getHttpRequestContextProvider();
            try {
                HttpRequestContextBaseAdapter context = new HttpRequestContextBaseAdapter((HttpRequestContextBase)new JaxrsRequestContext(requestContext, this.feature));
                httpRequestContextProvider.onRequestStarted((HttpRequestContext)context);
                JsonApiResponse jsonApiResponse = new JsonApiResponse();
                jsonApiResponse.setEntity(response);
                DocumentMappingConfig mappingConfig = new DocumentMappingConfig();
                ResourceInformation resourceInformation = registryEntry.get().getResourceInformation();
                Map<String, Set> jsonApiParameters = context.getRequestParameters().entrySet().stream().filter(entry -> this.isJsonApiParameter((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                QuerySpecUrlMapper urlMapper = this.feature.getBoot().getUrlMapper();
                QueryContext queryContext = context.getQueryContext();
                QuerySpec querySpec = urlMapper.deserialize(resourceInformation, jsonApiParameters, queryContext);
                ResourceRegistry resourceRegistry = this.feature.getBoot().getResourceRegistry();
                QuerySpecAdapter queryAdapter = new QuerySpecAdapter(querySpec, resourceRegistry, queryContext);
                responseContext.setEntity(documentMapper.toDocument(jsonApiResponse, (QueryAdapter)queryAdapter, mappingConfig).get());
                responseContext.getHeaders().put((Object)"Content-Type", Collections.singletonList("application/vnd.api+json"));
            }
            finally {
                httpRequestContextProvider.onRequestFinished();
            }
        } else if (this.isJsonApiResponse(responseContext) && !this.doNotWrap(response)) {
            Document document = new Document();
            document.setData(Nullable.of((Object)response));
            responseContext.setEntity((Object)document);
        }
    }

    private boolean isJsonApiParameter(String key) {
        for (QueryParameterType type : QueryParameterType.values()) {
            if (!key.startsWith(type.toString().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private Optional<RegistryEntry> getRegistryEntry(Object response) {
        if (response != null) {
            ResourceRegistry resourceRegistry;
            Class<?> responseClass = response.getClass();
            boolean resourceList = ResourceList.class.isAssignableFrom(responseClass);
            if (resourceList) {
                ResourceList responseList = (ResourceList)response;
                if (responseList.isEmpty()) {
                    return Optional.empty();
                }
                Class<?> elementType = responseList.get(0).getClass();
                for (int i = 0; i < responseList.size(); ++i) {
                    Class<?> otherType = responseList.get(i).getClass();
                    while (!elementType.isAssignableFrom(otherType)) {
                        elementType = elementType.getSuperclass();
                    }
                }
                responseClass = elementType;
            }
            if ((resourceRegistry = this.feature.getBoot().getResourceRegistry()).hasEntry(responseClass)) {
                return Optional.of(resourceRegistry.getEntry(responseClass));
            }
        }
        return Optional.empty();
    }

    private boolean isJsonApiResponse(ContainerResponseContext responseContext) {
        return JsonApiMediaType.APPLICATION_JSON_API_TYPE.equals((Object)responseContext.getMediaType());
    }

    private boolean doNotWrap(Object entity) {
        return entity instanceof Document || entity instanceof InputStream;
    }
}

