/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.rs.internal;

import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.information.repository.RepositoryAction;
import io.crnk.core.engine.security.SecurityProvider;
import io.crnk.core.module.Module;
import io.crnk.legacy.repository.information.DefaultResourceRepositoryInformationProvider;
import io.crnk.rs.internal.JaxrsSecurityProvider;
import io.crnk.rs.internal.WebApplicationExceptionMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.SecurityContext;

public class JaxrsModule
implements Module {
    private static final String ID_ACTION_PARAMETER = "{id}";
    private SecurityContext securityContext;

    public JaxrsModule(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public void setupModule(Module.ModuleContext context) {
        context.addExceptionMapper((ExceptionMapper)new WebApplicationExceptionMapper());
        if (this.securityContext != null) {
            context.addSecurityProvider((SecurityProvider)new JaxrsSecurityProvider(this.securityContext));
        }
    }

    public String getModuleName() {
        return "jaxrs";
    }

    public static class JaxrsRepositoryAction
    implements RepositoryAction {
        private String name;
        private RepositoryAction.RepositoryActionType actionType;

        public JaxrsRepositoryAction(String name, RepositoryAction.RepositoryActionType actionType) {
            this.name = name;
            this.actionType = actionType;
        }

        public String getName() {
            return this.name;
        }

        public RepositoryAction.RepositoryActionType getActionType() {
            return this.actionType;
        }
    }

    public static class JaxrsResourceRepositoryInformationProvider
    extends DefaultResourceRepositoryInformationProvider {
        protected Map<String, RepositoryAction> buildActions(Class<? extends Object> repositoryClass) {
            HashMap<String, RepositoryAction> actions = new HashMap<String, RepositoryAction>();
            this.setupClass(actions, repositoryClass);
            for (Class<?> interfaceClass : repositoryClass.getInterfaces()) {
                this.setupClass(actions, interfaceClass);
            }
            return actions;
        }

        private void setupClass(HashMap<String, RepositoryAction> actions, Class<? extends Object> repositoryClass) {
            for (Method method : repositoryClass.getMethods()) {
                this.setupMethod(actions, method);
            }
        }

        private void setupMethod(HashMap<String, RepositoryAction> actions, Method method) {
            Path pathAnnotation = method.getAnnotation(Path.class);
            boolean isJaxRs = this.isJaxRsMethod(method);
            if (pathAnnotation != null) {
                String path = this.normPath(pathAnnotation.value());
                String[] pathElements = path.split("\\/");
                this.checkPathElements(method, pathElements);
                RepositoryAction.RepositoryActionType actionType = pathElements[0].equals(JaxrsModule.ID_ACTION_PARAMETER) ? RepositoryAction.RepositoryActionType.RESOURCE : RepositoryAction.RepositoryActionType.REPOSITORY;
                String name = pathElements[pathElements.length - 1];
                JaxrsRepositoryAction action = new JaxrsRepositoryAction(name, actionType);
                actions.put(name, action);
            } else if (isJaxRs) {
                throw new IllegalStateException("JAXRS actions must be annotated with @Path: " + method);
            }
        }

        private void checkPathElements(Method method, String[] pathElements) {
            if (pathElements.length == 0 || pathElements.length == 1 && pathElements[0].isEmpty()) {
                throw new IllegalStateException("@Path value must not be empty: " + method);
            }
            if (pathElements.length > 2) {
                throw new IllegalStateException("@Path value must not contain more than two elements: " + method);
            }
            if (pathElements.length == 1 && pathElements[0].equals(JaxrsModule.ID_ACTION_PARAMETER)) {
                throw new IllegalStateException("single element in @Path cannot be {id}, add action name: " + method);
            }
            if (pathElements.length == 2 && !pathElements[0].equals(JaxrsModule.ID_ACTION_PARAMETER)) {
                throw new IllegalStateException("for two elements in @Path the first one must be {id}, the second the action name: " + method);
            }
        }

        private boolean isJaxRsMethod(Method method) {
            boolean isDelete;
            Path pathAnnotation = method.getAnnotation(Path.class);
            boolean isGet = method.getAnnotation(GET.class) != null;
            boolean isPost = method.getAnnotation(POST.class) != null;
            boolean isPut = method.getAnnotation(PUT.class) != null;
            boolean bl = isDelete = method.getAnnotation(DELETE.class) != null;
            if (isGet || isPost || isPut || isDelete) {
                return true;
            }
            if (pathAnnotation != null) {
                return true;
            }
            return this.hasJaxRsMethodParameters(method);
        }

        private boolean hasJaxRsMethodParameters(Method method) {
            Annotation[][] parameterAnnotationsArray = method.getParameterAnnotations();
            for (int paramIndex = 0; paramIndex < parameterAnnotationsArray.length; ++paramIndex) {
                Annotation[] parameterAnnotations;
                for (Annotation parameterAnnotation : parameterAnnotations = parameterAnnotationsArray[paramIndex]) {
                    if (!(parameterAnnotation instanceof PathParam) && !(parameterAnnotation instanceof QueryParam)) continue;
                    return true;
                }
            }
            return false;
        }

        private String normPath(String path) {
            String normPath = path;
            if (normPath.startsWith("/")) {
                normPath = normPath.substring(1);
            }
            if (normPath.endsWith("/")) {
                normPath = normPath.substring(0, normPath.length() - 1);
            }
            return normPath;
        }
    }
}

