/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.setup.boot.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.boot.CrnkBoot;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.url.ConstantServiceUrlProvider;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.core.queryspec.mapper.DefaultQuerySpecUrlMapper;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.core.queryspec.mapper.UrlBuilder;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingBehavior;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingSpec;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.servlet.CrnkFilter;
import io.crnk.servlet.internal.ServletModule;
import io.crnk.spring.exception.SpringExceptionModule;
import io.crnk.spring.internal.SpringServiceDiscovery;
import io.crnk.spring.setup.boot.core.CrnkBootConfigurer;
import io.crnk.spring.setup.boot.core.CrnkCoreProperties;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="crnk", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingBean(value={CrnkBoot.class})
@EnableConfigurationProperties(value={CrnkCoreProperties.class})
public class CrnkCoreAutoConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private CrnkCoreProperties properties;
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    private List<CrnkBootConfigurer> configurers;
    private SpringCrnkBoot boot = new SpringCrnkBoot();
    private SpringServiceDiscovery serviceDiscovery;

    @Autowired
    public CrnkCoreAutoConfiguration(final CrnkCoreProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
        this.serviceDiscovery = new SpringServiceDiscovery();
        this.boot.setServiceDiscovery((ServiceDiscovery)this.serviceDiscovery);
        this.boot.setObjectMapper(objectMapper);
        if (properties.getDomainName() != null && properties.getPathPrefix() != null) {
            String baseUrl = properties.getDomainName() + properties.getPathPrefix();
            this.boot.setServiceUrlProvider((ServiceUrlProvider)new ConstantServiceUrlProvider(baseUrl));
        }
        this.boot.setDefaultPageLimit(properties.getDefaultPageLimit());
        this.boot.setMaxPageLimit(properties.getMaxPageLimit());
        this.boot.setPropertiesProvider(new PropertiesProvider(){

            public String getProperty(String key) {
                if ("crnk.config.core.resource.domain".equals(key)) {
                    return properties.getDomainName();
                }
                if ("crnk.enforceIdName".equals(key)) {
                    return String.valueOf(properties.isEnforceIdName());
                }
                if ("crnk.config.web.path.prefix".equals(key)) {
                    return properties.getPathPrefix();
                }
                if ("crnk.config.resource.request.allowUnknownAttributes".equals(key)) {
                    return String.valueOf(properties.getAllowUnknownAttributes());
                }
                if ("crnk.config.resource.request.allowUnknownParameters".equals(key)) {
                    return String.valueOf(properties.getAllowUnknownParameters());
                }
                if ("crnk.config.resource.response.return_404".equals(key)) {
                    return String.valueOf(properties.getReturn404OnNull());
                }
                return CrnkCoreAutoConfiguration.this.applicationContext.getEnvironment().getProperty(key);
            }
        });
        this.boot.addModule((Module)new ServletModule(this.boot.getModuleRegistry().getHttpRequestContextProvider()));
        this.boot.addModule((Module)new SpringExceptionModule());
    }

    @Bean
    public ServiceDiscovery discovery() {
        return this.serviceDiscovery;
    }

    @Bean
    public CrnkBoot crnkBoot() {
        QuerySpecUrlMapper urlMapper;
        if (this.configurers != null) {
            for (CrnkBootConfigurer configurer : this.configurers) {
                configurer.configure(this.boot);
            }
        }
        if (this.properties.getEnforceDotSeparator() != null && (urlMapper = this.boot.getUrlMapper()) instanceof DefaultQuerySpecUrlMapper) {
            ((DefaultQuerySpecUrlMapper)urlMapper).setEnforceDotPathSeparator(this.properties.getEnforceDotSeparator().booleanValue());
        }
        return this.boot;
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceRegistry.class})
    public ResourceRegistry crnkResourceRegistry() {
        return this.boot.getResourceRegistry();
    }

    @Bean
    @ConditionalOnMissingBean(value={UrlBuilder.class})
    public UrlBuilder crnkUrlBuilder() {
        return this.boot.getUrlBuilder();
    }

    @Bean
    @ConditionalOnMissingBean(value={ModuleRegistry.class})
    public ModuleRegistry crnkModuleRegistry() {
        return this.boot.getModuleRegistry();
    }

    @Bean
    @ConditionalOnMissingBean(value={QuerySpecUrlMapper.class})
    public QuerySpecUrlMapper querySpecUrlMapper() {
        return new DefaultQuerySpecUrlMapper();
    }

    @Bean
    @ConditionalOnMissingBean(value={PagingBehavior.class})
    public PagingBehavior<OffsetLimitPagingSpec> offsetLimitPagingBehavior() {
        return new OffsetLimitPagingBehavior();
    }

    @Bean
    public CrnkFilter crnkFilter(CrnkBoot boot) {
        return new CrnkFilter(boot);
    }

    @Bean
    public ResourceRegistry resourceRegistry() {
        return this.boot.getResourceRegistry();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.serviceDiscovery.setApplicationContext(applicationContext);
    }

    public class SpringCrnkBoot
    extends CrnkBoot
    implements InitializingBean {
        public void afterPropertiesSet() {
            this.boot();
        }
    }
}

