/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.setup.boot.monitor;

import io.crnk.core.boot.CrnkBoot;
import io.crnk.core.engine.http.HttpRequestContextBase;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathBuilder;
import io.crnk.core.engine.internal.http.HttpRequestContextBaseAdapter;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.servlet.internal.ServletRequestContext;
import io.micrometer.core.instrument.Tag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.metrics.web.servlet.DefaultWebMvcTagsProvider;

public class CrnkWebMvcTagsProvider
extends DefaultWebMvcTagsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrnkWebMvcTagsProvider.class);
    private static final String URI_TAG = "uri";
    private final CrnkBoot boot;

    public CrnkWebMvcTagsProvider(CrnkBoot boot) {
        this.boot = boot;
        LOGGER.debug("initialized tag provider");
    }

    public Iterable<Tag> getTags(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable exception) {
        LOGGER.debug("getTags for {}", (Object)request.getRequestURI());
        Iterable tags = super.getTags(request, response, handler, exception);
        return this.enhanceUri(tags, request);
    }

    public Iterable<Tag> getLongRequestTags(HttpServletRequest request, Object handler) {
        LOGGER.debug("getLongRequestTags for {}", (Object)request.getRequestURI());
        Iterable tags = super.getLongRequestTags(request, handler);
        return this.enhanceUri(tags, request);
    }

    private Iterable<Tag> enhanceUri(Iterable<Tag> tags, HttpServletRequest request) {
        Tag uri = this.uri(request);
        if (uri != null) {
            ArrayList<Tag> enhancedTags = new ArrayList<Tag>();
            for (Tag tag : tags) {
                if (tag.getKey().equals(URI_TAG)) {
                    enhancedTags.add(uri);
                    continue;
                }
                enhancedTags.add(tag);
            }
            return enhancedTags;
        }
        return tags;
    }

    private Tag uri(HttpServletRequest request) {
        if (this.matchesPrefix(request)) {
            ServletContext servletContext = request.getServletContext();
            HttpRequestContextBaseAdapter context = new HttpRequestContextBaseAdapter((HttpRequestContextBase)new ServletRequestContext(servletContext, request, null, this.boot.getWebPathPrefix()));
            context.getQueryContext().initializeDefaults(this.boot.getResourceRegistry());
            String path = context.getPath();
            TypeParser typeParser = this.boot.getModuleRegistry().getTypeParser();
            PathBuilder pathBuilder = new PathBuilder(this.boot.getResourceRegistry(), typeParser);
            JsonPath jsonPath = pathBuilder.build(path, context.getQueryContext());
            if (jsonPath != null) {
                URL baseUrl;
                try {
                    baseUrl = new URL(context.getBaseUrl());
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
                String uri = baseUrl.getPath() + "/" + jsonPath.toGroupPath();
                LOGGER.debug("computed mvc tag: uri={}", (Object)uri);
                return Tag.of((String)URI_TAG, (String)uri);
            }
            LOGGER.debug("unknown path, using default mvc tags: uri={}", (Object)request.getRequestURI());
        }
        return null;
    }

    private boolean matchesPrefix(HttpServletRequest request) {
        String pathPrefix = UrlUtils.removeLeadingSlash((String)this.boot.getWebPathPrefix());
        String path = UrlUtils.removeLeadingSlash((String)request.getRequestURI().substring(request.getContextPath().length()));
        return pathPrefix == null || path.startsWith(pathPrefix);
    }
}

