/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.setup.boot.mvc;

import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.ErrorDataBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

public class CrnkErrorController
extends BasicErrorController {
    public CrnkErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        super(errorAttributes, errorProperties);
    }

    public CrnkErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, errorProperties, errorViewResolvers);
    }

    @RequestMapping(produces={"application/vnd.api+json"})
    @ResponseBody
    public ResponseEntity<Document> errorToJsonApi(HttpServletRequest request) {
        Map body = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.ALL));
        HttpStatus status = this.getStatus(request);
        ErrorDataBuilder errorDataBuilder = ErrorData.builder();
        for (Map.Entry attribute : body.entrySet()) {
            if (((String)attribute.getKey()).equals("status")) {
                errorDataBuilder.setStatus(attribute.getValue().toString());
                continue;
            }
            if (((String)attribute.getKey()).equals("error")) {
                errorDataBuilder.setTitle(attribute.getValue().toString());
                continue;
            }
            if (((String)attribute.getKey()).equals("message")) {
                errorDataBuilder.setDetail(attribute.getValue().toString());
                continue;
            }
            errorDataBuilder.addMetaField((String)attribute.getKey(), attribute.getValue());
        }
        Document document = new Document();
        document.setErrors(Arrays.asList(errorDataBuilder.build()));
        return new ResponseEntity((Object)document, status);
    }

    @RequestMapping
    @ResponseBody
    public ResponseEntity error(HttpServletRequest request) {
        return this.errorToJsonApi(request);
    }
}

