/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.setup.boot.core;

import io.crnk.core.engine.internal.utils.PropertyUtils;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

@Configuration
@ConditionalOnClass(value={Connector.class, AbstractHttp11Protocol.class})
public class CrnkTomcatAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrnkTomcatAutoConfiguration.class);
    private static final String PROPERTY_NAME = "relaxedQueryChars";

    @Bean
    public CrnkWebServerFactoryCustomizer tomcatCustomizer() {
        return new CrnkWebServerFactoryCustomizer();
    }

    public class CrnkWebServerFactoryCustomizer
    implements WebServerFactoryCustomizer<ConfigurableTomcatWebServerFactory>,
    Ordered {
        public int getOrder() {
            return 0;
        }

        public void customize(ConfigurableTomcatWebServerFactory factory) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new CrnkTomcatCustomizer()});
        }
    }

    class CrnkTomcatCustomizer
    implements TomcatConnectorCustomizer {
        CrnkTomcatCustomizer() {
        }

        public void customize(Connector connector) {
            ProtocolHandler protocolHandler = connector.getProtocolHandler();
            if (protocolHandler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol11 = (AbstractHttp11Protocol)protocolHandler;
                try {
                    String relaxedQueryChars = (String)PropertyUtils.getProperty((Object)protocol11, (String)CrnkTomcatAutoConfiguration.PROPERTY_NAME);
                    if (relaxedQueryChars == null) {
                        relaxedQueryChars = "";
                    }
                    relaxedQueryChars = relaxedQueryChars + "[]{}";
                    PropertyUtils.setProperty((Object)protocol11, (String)CrnkTomcatAutoConfiguration.PROPERTY_NAME, (Object)relaxedQueryChars);
                }
                catch (Exception e) {
                    LOGGER.debug("failed to set relaxed query charts, Tomcat might be outdated");
                }
            }
        }
    }
}

