/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.setup.boot.security;

import io.crnk.security.SecurityConfig;
import io.crnk.security.SecurityModule;
import io.crnk.spring.setup.boot.core.CrnkCoreAutoConfiguration;
import io.crnk.spring.setup.boot.security.CrnkSecurityProperties;
import io.crnk.spring.setup.boot.security.SecurityModuleConfigurer;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(prefix="crnk.security", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={SecurityModule.class})
@ConditionalOnMissingBean(value={SecurityModule.class})
@EnableConfigurationProperties(value={CrnkSecurityProperties.class})
@Import(value={CrnkCoreAutoConfiguration.class})
public class CrnkSecurityAutoConfiguration {
    @Autowired(required=false)
    private List<SecurityModuleConfigurer> configurers;

    @Bean
    public SecurityModule securityModule() {
        SecurityConfig.Builder config = SecurityConfig.builder();
        if (this.configurers != null) {
            for (SecurityModuleConfigurer configurer : this.configurers) {
                configurer.configure(config);
            }
        }
        return SecurityModule.newServerModule((SecurityConfig)config.build());
    }
}

