/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.ui.internal;

import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.internal.utils.IOUtils;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.ui.UIModuleConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class UIHttpRequestProcessor
implements HttpRequestProcessor {
    private final UIModuleConfig config;
    private static final Map<String, String> CONTENT_TYPES = new HashMap<String, String>();

    public UIHttpRequestProcessor(UIModuleConfig config) {
        this.config = config;
    }

    public void process(HttpRequestContext context) throws IOException {
        String pathPrefix = UrlUtils.removeLeadingSlash((String)UrlUtils.removeTrailingSlash((String)this.config.getPath())) + "/";
        String path = UrlUtils.removeLeadingSlash((String)context.getPath());
        if (context.getMethod().equals(HttpMethod.GET.toString()) && path.startsWith(pathPrefix)) {
            String fileName = path.substring(pathPrefix.length());
            if (fileName.isEmpty()) {
                fileName = "index.html";
            }
            String resourcePath = "io/crnk/ui/" + fileName;
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
            if (in != null) {
                context.setResponseHeader("Cache-Control", "no-cache, no-store");
                UIHttpRequestProcessor.setContentType(fileName, context);
                context.setResponse(200, IOUtils.readFully((InputStream)in));
            }
        }
    }

    private static void setContentType(String fileName, HttpRequestContext context) {
        String suffix;
        String contentType;
        int suffixSep = fileName.lastIndexOf(46);
        if (suffixSep != -1 && (contentType = CONTENT_TYPES.get(suffix = fileName.substring(suffixSep + 1))) != null) {
            context.setContentType(contentType);
        }
    }

    static {
        CONTENT_TYPES.put("css", "text/css");
        CONTENT_TYPES.put("html", "text/html");
        CONTENT_TYPES.put("js", "application/javascript");
    }
}

