/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.ui;

import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleExtension;
import io.crnk.ui.UIModuleConfig;
import io.crnk.ui.internal.UIHttpRequestProcessor;
import java.lang.reflect.Method;

public class UIModule
implements Module {
    private final UIModuleConfig config;

    protected UIModule() {
        this.config = null;
    }

    protected UIModule(UIModuleConfig config) {
        this.config = config;
    }

    public static UIModule create(UIModuleConfig config) {
        return new UIModule(config);
    }

    public String getModuleName() {
        return "ui";
    }

    public void setupModule(Module.ModuleContext context) {
        context.addHttpRequestProcessor((HttpRequestProcessor)new UIHttpRequestProcessor(this.config));
        this.setupHomeExtension(context);
    }

    public UIModuleConfig getConfig() {
        return this.config;
    }

    private void setupHomeExtension(Module.ModuleContext context) {
        if (ClassUtils.existsClass((String)"io.crnk.home.HomeModuleExtension")) {
            try {
                Class<?> clazz = Class.forName("io.crnk.ui.internal.UiHomeModuleExtensionFactory");
                Method method = clazz.getMethod("create", UIModuleConfig.class);
                ModuleExtension homeExtension = (ModuleExtension)method.invoke(clazz, this.config);
                context.addExtension(homeExtension);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

