/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cronapi.CronapiCloud;
import cronapi.CronapiConfigurator;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.SecurityBeanFilter;
import cronapi.Var;
import cronapi.cloud.CloudFactory;
import cronapi.cloud.CloudManager;
import cronapi.cloud.FieldData;
import cronapi.database.DataSource;
import cronapi.i18n.Messages;
import cronapi.rest.CronapiREST;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.persistence.Id;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.EdmDateTime;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClassInterface;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class Utils {
    private static final Map<String, DateFormat[]> DATE_FORMATS = new HashMap<String, DateFormat[]>();
    private static final Map<String, DateFormat> DATETIME_FORMAT = new HashMap<String, DateFormat>();
    private static final Map<String, DateFormat> PARSE_DATETIME_FORMAT = new HashMap<String, DateFormat>();
    public static final String SL = "cBN3GwM6eBYKHw80CjhdDSswaQEsHUU0CSxJFwA5Xhg/CWwJFS11FS8tUUcpCAwDP05wACh2eTA2TlMRLwpCb3QfZDINGh8+NhZlPxMHRjEpMmg4CDtmF3RWcyAjdkQTMDxVRTAMW24BSmcRIRxEIhFVbkU0GQMVAA4KAyt2djEtEUQybzh8LiA3dioCD3tuDk5MHA94fhgqN18iLgFAFX8TeRQgLX08LSl0FSw5RjgXDUsbPS9+FygOWhJzHUUQdAYMS3VhRSkBXA0qLzZTHG0KCEFxCAJtPEp8AXQ7dxMpHwsmIytWNCAjZUdwKlIodQ4ORDAiYi0hIHYHDAJ9AC4dTSYgKlkyLlQNGT54eDcLFXIAMSN+LignaAsFAHYvMA1fKzMYQik1LGQLCA9VNjIUZBB9CkIxIQBJORU6XTQlVw4JHj4MazwgBDdrHVJjKj1VODF4WyoqLU4iEhtmHhAmCxQeZV8/PwBUOyYHAh4LXUUVdRpiaAQPcEASex8ZdFZeChV3cmkgI2g+ayJ5CjIKBDAeN34AEghMISo8VzEJSlkHFXYMC3QgbjAVFkUUCSd4FXQ8eGMsCXcfEwJEEWk/cQQnGkE+DzZxQi4ZARQiUgU6IhZGa3IAVwJ1dkM0DTxqAB0Deyt0NllCMXlXGDAPSUQmGmwsLT9NEXICXyM3CVpBMgV6NB8GWRV3JXYJFVwJFSwMcjkOLmwAEB1FbQBWUxkVHGcpNz1yQhA0QWJpJn8BBj9McWkOChIrOQYeAFFrEjR+ZBwISg9cIn5jHSEJTxwDJgIsAA4SKwJ+QhJzA2cFNgpTdQMBWkIdNHoiDhByJQ4EbjILVnQfdX9RMxcAVyV2AA0MciltG3UBBAkjF1oadT5WcQ83UTo+DWMTB04FKT0lXisoXAo8MAgfNT4zSzoeKmwILSxqNiV+BB8rEHcGKCRkGQVQTTgJA3ArLQxFBBY5CWc=";
    public static final String K = "KzsnKD8iNXI4TlZUcFV6eg==";
    private static final ISO8601DateFormat ISO_FORMAT = new ISO8601DateFormat(){

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            toAppendTo.append(ISO8601Utils.format((Date)date, (boolean)false, (TimeZone)TimeZone.getDefault()));
            return toAppendTo;
        }
    };

    public static boolean deleteFolder(File dir) throws Exception {
        if (dir.isDirectory()) {
            Path rootPath = Paths.get(dir.getPath(), new String[0]);
            Files.walk(rootPath, FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).peek(System.out::println).forEach(File::delete);
        }
        return dir.delete();
    }

    public static String encodeMD5(String string) throws Exception {
        return Utils.encodeMD5(string.getBytes(CronapiConfigurator.ENCODING));
    }

    public static String encodeMD5(byte[] bytes) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(bytes);
        byte[] digest = md.digest();
        String myChecksum = DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
        return myChecksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeMD5(File file) throws Exception {
        FilterInputStream in = null;
        FileInputStream fstream = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            fstream = new FileInputStream(file);
            in = new DataInputStream(fstream);
            byte[] bin = new byte[254];
            while (in.available() != 0) {
                int bytes = ((DataInputStream)in).read(bin);
                md5.update(bin, 0, bytes);
            }
            byte[] digest = md5.digest();
            String string = DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fstream != null) {
                fstream.close();
            }
        }
    }

    public static void copyFileTo(File src, File dst) throws Exception {
        if (src == null || dst == null) {
            return;
        }
        Files.copy(Paths.get(src.getPath(), new String[0]), Paths.get(dst.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public static StringBuilder getFileContent(FileInputStream fstream) throws Exception {
        int bytesRead;
        BufferedInputStream bis = new BufferedInputStream(fstream);
        if (Utils.isPDF(bis)) {
            bis.reset();
            return Utils.getFileContentPDF(bis);
        }
        bis.reset();
        byte[] buffer = new byte[1024];
        StringBuilder fileContent = new StringBuilder();
        while ((bytesRead = bis.read(buffer)) != -1) {
            fileContent.append(new String(buffer, 0, bytesRead));
        }
        return fileContent;
    }

    public static StringBuilder getFileContentPDF(BufferedInputStream fstream) throws Exception {
        PDDocument document = PDDocument.load((InputStream)fstream);
        PDFTextStripper pdfStripper = new PDFTextStripper();
        StringBuilder out = new StringBuilder(pdfStripper.getText(document));
        document.close();
        return out;
    }

    public static boolean isPDF(BufferedInputStream bis) throws IOException {
        byte[] pdfSignature = new byte[5];
        bis.mark(10);
        if (bis.read(pdfSignature) == 5) {
            String header = new String(pdfSignature);
            return header.equals("%PDF-");
        }
        return false;
    }

    public static String getFileContent(String file) throws Exception {
        return FileUtils.readFileToString((File)new File(file));
    }

    public static boolean stringToBoolean(String str) {
        if (str == null) {
            return false;
        }
        return Boolean.valueOf(str.trim());
    }

    public static byte[] getFromBase64(String base64) {
        byte[] bytes = null;
        if (base64 != null && !base64.equals("")) {
            bytes = Base64.getDecoder().decode(base64);
        }
        return bytes;
    }

    public static String stringToJs(String string) {
        return StringEscapeUtils.escapeEcmaScript((String)string);
    }

    public static int getFromCalendar(Date date, int field) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(field);
    }

    public static List<Field> findIds(Object obj) {
        Field[] fields = obj instanceof Class ? ((Class)obj).getDeclaredFields() : obj.getClass().getDeclaredFields();
        ArrayList<Field> pks = new ArrayList<Field>();
        for (Field f : fields) {
            Annotation[] annotations = f.getDeclaredAnnotations();
            for (int i = 0; i < annotations.length; ++i) {
                if (!annotations[i].annotationType().equals(Id.class)) continue;
                pks.add(f);
            }
        }
        return pks;
    }

    public static Method findMethod(Object obj, String method) {
        Method[] methods;
        if (obj == null) {
            return null;
        }
        for (Method m : methods = obj instanceof Class ? ((Class)obj).getMethods() : obj.getClass().getMethods()) {
            if (!m.getName().equalsIgnoreCase(method)) continue;
            return m;
        }
        return null;
    }

    public static List<FieldData> getFieldsWithAnnotationCloud(Object obj) {
        LinkedList<FieldData> fields = new LinkedList<FieldData>();
        Class<?> c = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        Field[] fieldsArr = c.getDeclaredFields();
        ArrayList<Field> allFields = new ArrayList<Field>(Arrays.asList(fieldsArr));
        for (Field field : allFields) {
            if (field.getDeclaredAnnotations().length <= 0) continue;
            Annotation[] fieldAnnots = field.getDeclaredAnnotations();
            for (int i = 0; i < fieldAnnots.length; ++i) {
                CronapiCloud ann;
                if (!fieldAnnots[i].toString().contains("CronapiCloud") || (ann = (CronapiCloud)fieldAnnots[i]).type() == null) continue;
                FieldData fieldData = new FieldData();
                fieldData.field = field;
                fieldData.data = ann;
                fields.add(fieldData);
            }
        }
        return fields;
    }

    public static List<String> getFieldsWithAnnotationByteHeaderSignature(Object obj) {
        LinkedList<String> fields = new LinkedList<String>();
        if (obj != null) {
            Class<?> c = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            Field[] fieldsArr = c.getDeclaredFields();
            ArrayList<Field> allFields = new ArrayList<Field>(Arrays.asList(fieldsArr));
            for (Field field : allFields) {
                if (field.getDeclaredAnnotations().length <= 0) continue;
                Annotation[] fieldAnnots = field.getDeclaredAnnotations();
                for (int i = 0; i < fieldAnnots.length; ++i) {
                    if (!fieldAnnots[i].toString().contains("CronapiByteHeaderSignature")) continue;
                    fields.add(field.getName());
                }
            }
        }
        return fields;
    }

    public static List<String> getFieldsWithAnnotationId(Object obj) {
        ArrayList<String> fields = new ArrayList<String>();
        Class<?> c = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        Field[] fieldsArr = c.getDeclaredFields();
        ArrayList<Field> allFields = new ArrayList<Field>(Arrays.asList(fieldsArr));
        for (Field field : allFields) {
            if (field.getDeclaredAnnotations().length <= 0) continue;
            Annotation[] fieldAnnots = field.getDeclaredAnnotations();
            for (int i = 0; i < fieldAnnots.length; ++i) {
                if (!fieldAnnots[i].toString().contains("@javax.persistence.Id(")) continue;
                fields.add(field.getName());
            }
        }
        return fields;
    }

    public static CronapiCloud getAnnotationCloud(Object obj, String fieldName) {
        CronapiCloud result;
        block3: {
            Class<?> c = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            result = null;
            try {
                Field field = c.getDeclaredField(fieldName);
                if (field.getDeclaredAnnotations().length <= 0) break block3;
                Annotation[] fieldAnnots = field.getDeclaredAnnotations();
                for (int i = 0; i < fieldAnnots.length; ++i) {
                    if (!fieldAnnots[i].toString().contains("CronapiCloud")) continue;
                    result = (CronapiCloud)fieldAnnots[i];
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        try {
            fieldName = ((String)fieldName).substring(0, 1).toUpperCase() + ((String)fieldName).substring(1);
            Method getMethod = Utils.findMethod(obj, "get" + (String)fieldName);
            Object result = getMethod.invoke(obj, new Object[0]);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void updateField(Object obj, String fieldName, Object fieldValue) {
        try {
            Method setMethod = Utils.findMethod(obj, "set" + fieldName);
            if (setMethod != null) {
                if (fieldValue instanceof Var) {
                    fieldValue = ((Var)fieldValue).getObject(setMethod.getParameterTypes()[0]);
                } else {
                    Var tVar = Var.valueOf(fieldValue);
                    fieldValue = tVar.getObject(setMethod.getParameterTypes()[0]);
                }
            } else {
                throw new RuntimeException("Field " + fieldName + " not found");
            }
            setMethod.invoke(obj, fieldValue);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Calendar toGenericCalendar(String value) {
        Date date = null;
        try {
            if (NumberUtils.isNumber((String)value)) {
                Double d = Double.valueOf(value);
                date = new Date(d.longValue());
            }
        }
        catch (Exception d) {
            // empty catch block
        }
        if (date == null) {
            DateFormat[] formats;
            if (value.startsWith("cronapi.toDate(") && value.endsWith(")")) {
                value = value.substring(16, value.length() - 2);
            }
            if (value.startsWith("datetime'")) {
                try {
                    return (Calendar)EdmDateTime.getInstance().valueOfString(value, EdmLiteralKind.URI, null, Calendar.class);
                }
                catch (EdmSimpleTypeException d) {
                    // empty catch block
                }
            }
            if (value.startsWith("datetimeoffset'")) {
                try {
                    return (Calendar)EdmDateTimeOffset.getInstance().valueOfString(value, EdmLiteralKind.URI, null, Calendar.class);
                }
                catch (EdmSimpleTypeException d) {
                    // empty catch block
                }
            }
            if ((formats = DATE_FORMATS.get(Messages.getLocale().getLanguage())) == null) {
                formats = DATE_FORMATS.get("pt");
            }
            for (DateFormat format : formats) {
                try {
                    date = format.parse(value);
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        if (date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            return c;
        }
        return null;
    }

    public static TimeZone toTimeZone(Var timeZone) {
        if (timeZone != null && !timeZone.isEmptyOrNull().booleanValue()) {
            if (!timeZone.isString()) {
                int tz = timeZone.getObjectAsInt();
                String id = "GMT" + (tz < 0 ? "-" : "+") + (tz < 10 ? "0" : "") + Math.abs(tz) + ":00";
                return TimeZone.getTimeZone(id);
            }
            return TimeZone.getTimeZone(timeZone.getObjectAsString());
        }
        return TimeZone.getDefault();
    }

    public static String unquote(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str) & str.length() >= 2 && (str.startsWith("\"") || str.startsWith("'")) && (str.endsWith("\"") || str.endsWith("'"))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static Calendar toCalendar(String value, String mask) {
        return Utils.toCalendar(value, mask, null);
    }

    public static Calendar toCalendar(String value, String mask, TimeZone timeZone) {
        if (value == null) {
            return null;
        }
        value = Utils.unquote(value);
        try {
            if (mask != null && !mask.isEmpty()) {
                SimpleDateFormat format = new SimpleDateFormat(mask);
                if (timeZone != null) {
                    format.setTimeZone(timeZone);
                }
                Date date = format.parse(value);
                Calendar c = Calendar.getInstance();
                c.setTime(date);
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Utils.toGenericCalendar(value);
    }

    public static final DateFormat getParseDateFormat() {
        DateFormat format = PARSE_DATETIME_FORMAT.get(Messages.getLocale().getLanguage());
        if (format == null) {
            format = PARSE_DATETIME_FORMAT.get("pt");
        }
        return format;
    }

    public static final DateFormat getDateFormat() {
        DateFormat format = DATETIME_FORMAT.get(Messages.getLocale().getLanguage());
        if (format == null) {
            format = DATETIME_FORMAT.get("pt");
        }
        return format;
    }

    public static final DateFormat getISODateFormat() {
        return ISO_FORMAT;
    }

    private static DateFormat[] getGenericParseDateFormat(Locale locale) {
        String datePattern = Messages.getBundle(locale).getString("ParseDateFormat");
        String[] formats = new String[]{datePattern + " H:m:s.SSS", datePattern + " H:m:s", datePattern + " H:m", "yyyy-M-d H:m:s.SSS", "yyyy-M-d H:m:s", "yyyy-M-d H:m", datePattern, "yyyy-M-d", "H:m:s", "H:m"};
        DateFormat[] dateFormats = new DateFormat[formats.length + 1];
        dateFormats[0] = new ISO8601DateFormat();
        for (int i = 0; i < formats.length; ++i) {
            dateFormats[i + 1] = new SimpleDateFormat(formats[i]);
        }
        return dateFormats;
    }

    private static String fillIndexesIfExists(List<String> indexes, String key) {
        String index = null;
        if (key.contains("[") && key.endsWith("]")) {
            String searchBrackets = key;
            while (searchBrackets.indexOf("[") > -1) {
                index = searchBrackets.substring(searchBrackets.indexOf("[") + 1, searchBrackets.indexOf("]"));
                indexes.add(index);
                if (searchBrackets.indexOf("]") < searchBrackets.length() - 1) {
                    searchBrackets = searchBrackets.substring(searchBrackets.indexOf("]") + 1);
                    continue;
                }
                searchBrackets = searchBrackets.substring(searchBrackets.indexOf("]"));
            }
            key = key.substring(0, key.indexOf("["));
        }
        return key;
    }

    private static final Object getValueByKey(Object obj, String key) {
        if (key.equals("this")) {
            return obj;
        }
        if (obj instanceof JsonObject) {
            return ((JsonObject)obj).get(key);
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(key);
        }
        if (obj instanceof DataSource) {
            return ((DataSource)obj).getObject(key);
        }
        if (obj instanceof VirtualClassInterface) {
            return ((VirtualClassInterface)obj).get(key);
        }
        return Utils.getFieldReflection(obj, key);
    }

    private static final Object getFieldReflection(Object obj, String key) {
        Object o;
        block7: {
            o = null;
            try {
                Method getMethod;
                Object keyWithGet = String.format("get%s", Character.valueOf(Character.toUpperCase(key.charAt(0))));
                if (key.length() > 1) {
                    keyWithGet = (String)keyWithGet + key.substring(1);
                }
                if ((getMethod = Utils.findMethod(obj, (String)keyWithGet)) != null) {
                    o = getMethod.invoke(obj, null);
                    break block7;
                }
                getMethod = Utils.findMethod(obj, "get");
                if (getMethod != null) {
                    o = getMethod.invoke(obj, key);
                    break block7;
                }
                throw new Exception("method not found");
            }
            catch (Exception e) {
                try {
                    Class<?> c = obj.getClass();
                    Field f = c.getDeclaredField(key);
                    f.setAccessible(true);
                    o = f.get(obj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return o;
    }

    private static final Object getValueByIndex(Object obj, int idx) {
        try {
            if (obj instanceof JsonArray) {
                return ((JsonArray)obj).get(idx);
            }
            if (obj instanceof List) {
                return ((List)obj).get(idx);
            }
            if (obj.getClass().isArray()) {
                return ((Object[])obj)[idx];
            }
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final Object setValueByIndex(Object list, Object valueToSet, int idx) {
        Object val = valueToSet;
        if (val instanceof Var) {
            val = ((Var)val).getObject();
        }
        if (list instanceof JsonArray) {
            if (idx <= ((JsonArray)list).size() - 1) {
                if (val instanceof JsonElement) {
                    ((JsonArray)list).set(idx, (JsonElement)val);
                } else if (val instanceof Character) {
                    ((JsonArray)list).set(idx, (JsonElement)new JsonPrimitive((Character)val));
                } else if (val instanceof Number) {
                    ((JsonArray)list).set(idx, (JsonElement)new JsonPrimitive((Number)val));
                } else if (val instanceof Boolean) {
                    ((JsonArray)list).set(idx, (JsonElement)new JsonPrimitive((Boolean)val));
                } else if (val instanceof String) {
                    ((JsonArray)list).set(idx, (JsonElement)new JsonPrimitive((String)val));
                }
            } else {
                for (int i = 0; i < idx; ++i) {
                    if (i < ((JsonArray)list).size()) continue;
                    ((JsonArray)list).add((JsonElement)((JsonObject)null));
                }
                if (val instanceof JsonElement) {
                    ((JsonArray)list).add((JsonElement)val);
                } else if (val instanceof Character) {
                    ((JsonArray)list).add((Character)val);
                } else if (val instanceof Number) {
                    ((JsonArray)list).add((Number)val);
                } else if (val instanceof Boolean) {
                    ((JsonArray)list).add((Boolean)val);
                } else if (val instanceof String) {
                    ((JsonArray)list).add((String)val);
                }
            }
        } else if (list instanceof List) {
            if (idx <= ((List)list).size() - 1) {
                ((List)list).set(idx, val);
            } else {
                for (int i = 0; i < idx; ++i) {
                    if (i < ((List)list).size()) continue;
                    ((List)list).add(null);
                }
                ((List)list).add(val);
            }
        } else if (idx <= ((Object[])list).length - 1) {
            ((Object[])list)[idx] = val;
        } else {
            int i;
            ArrayList<Object> tempToArray = new ArrayList<Object>();
            for (i = 0; i < ((Object[])list).length; ++i) {
                tempToArray.add(((Object[])list)[i]);
            }
            for (i = 0; i < idx; ++i) {
                if (i < tempToArray.size()) continue;
                tempToArray.add(null);
            }
            tempToArray.add(val);
            Object newArray = Array.newInstance(val.getClass(), tempToArray.size());
            for (int i2 = 0; i2 < tempToArray.size(); ++i2) {
                Array.set(newArray, i2, tempToArray.get(i2));
            }
            return newArray;
        }
        return null;
    }

    private static final void setValueInObj(Object obj, String key, Object valueToSet) {
        if (obj instanceof Var) {
            obj = ((Var)obj).getObject();
        }
        if (valueToSet instanceof Var) {
            valueToSet = ((Var)valueToSet).getObject();
        }
        if (obj instanceof JsonObject) {
            if (valueToSet instanceof JsonElement) {
                ((JsonObject)obj).add(key, (JsonElement)valueToSet);
            } else if (valueToSet instanceof Character) {
                ((JsonObject)obj).addProperty(key, (Character)valueToSet);
            } else if (valueToSet instanceof Number) {
                ((JsonObject)obj).addProperty(key, (Number)valueToSet);
            } else if (valueToSet instanceof Boolean) {
                ((JsonObject)obj).addProperty(key, (Boolean)valueToSet);
            } else if (valueToSet instanceof String) {
                ((JsonObject)obj).addProperty(key, (String)valueToSet);
            }
        } else if (obj instanceof Map) {
            ((Map)obj).put(key, valueToSet);
        } else if (obj instanceof DataSource) {
            ((DataSource)obj).updateField(key, valueToSet);
        } else {
            Utils.setValueInObjByReflection(obj, key, valueToSet);
        }
    }

    private static final void setValueInObjByReflection(Object obj, String key, Object valueToSet) {
        block7: {
            try {
                Method setMethod;
                Object keyWithSet = String.format("set%s", Character.valueOf(Character.toUpperCase(key.charAt(0))));
                if (key.length() > 1) {
                    keyWithSet = (String)keyWithSet + key.substring(1);
                }
                if ((setMethod = Utils.findMethod(obj, (String)keyWithSet)) != null) {
                    valueToSet = Var.valueOf(valueToSet).getObject(setMethod.getParameterTypes()[0]);
                    setMethod.invoke(obj, valueToSet);
                    break block7;
                }
                setMethod = Utils.findMethod(obj, "put");
                if (setMethod != null) {
                    valueToSet = Var.valueOf(valueToSet).getObject();
                    setMethod.invoke(obj, key, valueToSet);
                    break block7;
                }
                throw new Exception("method not found");
            }
            catch (Exception e) {
                try {
                    Object o = null;
                    Class<?> c = obj.getClass();
                    Field f = c.getDeclaredField(key);
                    f.setAccessible(true);
                    f.set(obj, valueToSet);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static final Object addEmptyDefaultValueByKey(Object obj, String key) {
        Object value = null;
        if (obj instanceof JsonObject) {
            value = new JsonObject();
            ((JsonObject)obj).add(key, (JsonElement)value);
        } else {
            value = new HashMap();
            ((Map)obj).put(key, value);
        }
        return value;
    }

    private static Object addOrSetEmptyValueOnArray(Object obj, String keyOrPreviusIdx, int idx) {
        ArrayList value = Utils.getPreviousListFromArray(obj, keyOrPreviusIdx);
        if (obj instanceof JsonElement) {
            if (value == null || !(value instanceof JsonArray)) {
                value = new JsonArray();
            }
            Utils.setValueByIndex(value, new JsonObject(), idx);
        } else {
            if (value == null || !(value instanceof List)) {
                value = new ArrayList();
            }
            Utils.setValueByIndex(value, new HashMap(), idx);
        }
        if (obj instanceof JsonObject || obj instanceof Map) {
            Utils.setValueInObj(obj, keyOrPreviusIdx, value);
        } else if (obj instanceof JsonArray || obj instanceof List) {
            Utils.setValueByIndex(obj, value, Integer.parseInt(keyOrPreviusIdx));
        }
        return value;
    }

    private static Object getPreviousListFromArray(Object obj, String keyOrPreviusIdx) {
        try {
            if (obj instanceof JsonElement) {
                if (obj instanceof JsonObject) {
                    return ((JsonObject)obj).get(keyOrPreviusIdx);
                }
                if (obj instanceof JsonArray) {
                    return ((JsonArray)obj).get(Integer.parseInt(keyOrPreviusIdx));
                }
            } else {
                if (obj instanceof Map) {
                    return ((Map)obj).get(keyOrPreviusIdx);
                }
                if (obj instanceof List) {
                    return ((List)obj).get(Integer.parseInt(keyOrPreviusIdx));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Object addEmptyDefaultValuesByIndexes(Object obj, String key, List<String> indexes) {
        Object value = obj;
        for (int i = 0; i < indexes.size(); ++i) {
            String idx = indexes.get(i);
            value = i == 0 ? Utils.addOrSetEmptyValueOnArray(value, key, Integer.parseInt(idx)) : Utils.addOrSetEmptyValueOnArray(value, String.valueOf(indexes.get(i - 1)), Integer.parseInt(idx));
        }
        return Utils.getValueByKey(obj, key);
    }

    private static Object createObjectPath(Object obj, String key, List<String> indexes) {
        Object value = null;
        value = indexes.size() == 0 ? Utils.addEmptyDefaultValueByKey(obj, key) : Utils.addEmptyDefaultValuesByIndexes(obj, key, indexes);
        return value;
    }

    public static final Object mapGetObjectPathExtractElement(Object obj, String key, boolean createIfNotExist) throws Exception {
        ArrayList<String> indexes;
        Object value;
        if (obj instanceof Var) {
            obj = ((Var)obj).getObject();
        }
        if (((value = Utils.getValueByKey(obj, key = Utils.fillIndexesIfExists(indexes = new ArrayList<String>(), key))) == null || value instanceof JsonNull) && createIfNotExist) {
            value = Utils.createObjectPath(obj, key, indexes);
        }
        if (indexes.size() > 0) {
            for (String idx : indexes) {
                Object o = value;
                if (value instanceof Var) {
                    o = ((Var)value).getObject();
                }
                if ((value = Utils.getValueByIndex(o, Integer.parseInt(idx))) != null && !(value instanceof JsonNull) || !createIfNotExist) continue;
                Utils.createObjectPath(obj, key, indexes);
                value = Utils.getValueByIndex(o, Integer.parseInt(idx));
            }
        }
        return value;
    }

    private static final void setValueInArray(Object obj, String key, Object valueToSet) {
        if (obj instanceof Var) {
            obj = ((Var)obj).getObject();
        }
        if (valueToSet instanceof Var) {
            valueToSet = ((Var)valueToSet).getObject();
        }
        ArrayList<String> indexes = new ArrayList<String>();
        key = Utils.fillIndexesIfExists(indexes, key);
        Object value = Utils.getValueByKey(obj, key);
        if (indexes.size() > 0) {
            for (int i = 0; i < indexes.size(); ++i) {
                String idx = (String)indexes.get(i);
                Object o = value;
                if (value instanceof Var) {
                    o = ((Var)value).getObject();
                }
                if (i == indexes.size() - 1) {
                    Object result = Utils.setValueByIndex(o, valueToSet, Integer.parseInt(idx));
                    if (result == null) continue;
                    Utils.setValueInObj(obj, key, result);
                    continue;
                }
                value = Utils.getValueByIndex(o, Integer.parseInt(idx));
            }
        }
    }

    public static final void mapSetObject(Object obj, String key, Object valueToSet) throws Exception {
        if (key.endsWith("]")) {
            Utils.mapGetObjectPathExtractElement(obj, key, true);
            Utils.setValueInArray(obj, key, valueToSet);
        } else {
            Utils.setValueInObj(obj, key, valueToSet);
        }
    }

    public static final List<Var> getParamsAndExecuteBlockParams(JsonObject query, CronapiREST.TranslationPath translationPath) {
        int paramBlockly = 0;
        int paramTranslationPath = 0;
        LinkedList<Var> params = new LinkedList<Var>();
        JsonArray array = query.get("queryParamsValues").getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject paramObj = array.get(i).getAsJsonObject();
            if (paramObj.get("fieldValue").isJsonObject()) {
                JsonObject jsonCallBlockly = new JsonObject();
                jsonCallBlockly.add("blockly", (JsonElement)paramObj.get("fieldValue").getAsJsonObject());
                Var result = QueryManager.executeBlockly(jsonCallBlockly, "GET", null).getObjectAsPOJOList();
                params.add(Var.valueOf(result.getObjectAsList().get(0)).getField("value"));
                ++paramBlockly;
                continue;
            }
            if (paramObj.get("fieldValue").isJsonPrimitive() && paramObj.get("fieldValue").getAsString().trim().length() > 0 && !paramObj.get("fieldValue").getAsString().trim().startsWith("{{") && !paramObj.get("fieldValue").getAsString().trim().endsWith("}}")) {
                params.add(Var.valueOf(paramObj.get("fieldValue").getAsString()));
                ++paramBlockly;
                continue;
            }
            if (translationPath.params.length <= params.size() - paramBlockly) continue;
            params.add(translationPath.params[params.size() - paramBlockly]);
            ++paramTranslationPath;
        }
        if (paramTranslationPath < translationPath.params.length) {
            Arrays.stream(translationPath.params).forEach(p -> params.add((Var)p));
        }
        return params;
    }

    public static final Field getFieldOfClass(Object obj, String field) {
        try {
            Object o = null;
            Class<?> c = obj.getClass();
            Field f = c.getDeclaredField(field);
            f.setAccessible(true);
            return f;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isEntityClass(Object obj) {
        Boolean isEntity = false;
        Class<?> c = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        Annotation[] fieldAnnots = c.getDeclaredAnnotations();
        for (int i = 0; i < fieldAnnots.length; ++i) {
            if (!fieldAnnots[i].toString().contains("@javax.persistence.Entity(")) continue;
            isEntity = true;
            break;
        }
        return isEntity;
    }

    public static String addFilterInSQLClause(String sql, String filter) {
        int indexGroupBy = -1;
        int indexOrderBy = -1;
        Object result = "";
        String sqlLower = sql.toLowerCase();
        indexGroupBy = sqlLower.indexOf("group by");
        indexOrderBy = sqlLower.indexOf("order by");
        if (indexGroupBy > -1) {
            result = sql.substring(0, indexGroupBy);
            result = (String)result + " " + filter + " ";
            result = (String)result + sql.substring(indexGroupBy);
        } else if (indexOrderBy > -1) {
            result = sql.substring(0, indexOrderBy);
            result = (String)result + " " + filter + " ";
            result = (String)result + sql.substring(indexOrderBy);
        } else {
            result = (String)result + sql + " " + filter;
        }
        return result;
    }

    public static void processCloudFields(Object toSaveParam) {
        Object toSave = toSaveParam;
        List<FieldData> fieldsAnnotationCloud = Utils.getFieldsWithAnnotationCloud(toSave);
        List<String> fieldsIds = Utils.getFieldsWithAnnotationId(toSave);
        for (FieldData fieldData : fieldsAnnotationCloud) {
            CloudManager cloudManager = CloudManager.newInstance().byID(fieldsIds.toArray(new String[0])).toField(fieldData.field.getName());
            CloudFactory factory = cloudManager.byEntity(toSave).build();
            factory.send(fieldData).upload();
            factory.getFiles().forEach(f -> Utils.updateFieldOnFiltered(toSave, f.getFieldReference(), f.getFileDirectUrl()));
        }
    }

    public static void updateFieldOnFiltered(Object obj, String fieldName, Object fieldValue) {
        try {
            boolean update = true;
            if (RestClient.getRestClient().isFilteredEnabled()) {
                update = SecurityBeanFilter.includeProperty(obj.getClass(), fieldName, null);
            }
            if (update) {
                Utils.updateField(obj, fieldName, fieldValue);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        DATE_FORMATS.put("pt", Utils.getGenericParseDateFormat(new Locale("pt", "BR")));
        DATE_FORMATS.put("en", Utils.getGenericParseDateFormat(new Locale("en", "US")));
        PARSE_DATETIME_FORMAT.put("pt", new SimpleDateFormat(Messages.getBundle(new Locale("pt", "BR")).getString("ParseDateFormat")));
        PARSE_DATETIME_FORMAT.put("en", new SimpleDateFormat(Messages.getBundle(new Locale("en", "US")).getString("ParseDateFormat")));
        DATETIME_FORMAT.put("pt", new SimpleDateFormat(Messages.getBundle(new Locale("pt", "BR")).getString("DateTimeFormat")));
        DATETIME_FORMAT.put("en", new SimpleDateFormat(Messages.getBundle(new Locale("en", "US")).getString("DateTimeFormat")));
    }
}

