/*
 * Decompiled with CFR 0.152.
 */
package cronapi.validation;

import cronapi.CronapiMetaData;
import cronapi.Var;

@CronapiMetaData(category=CronapiMetaData.CategoryType.VALIDATION, categoryTags={"Validation", "Valida\u00e7\u00e3o"})
public class Operations {
    @CronapiMetaData(type="function", name="{{validateCPF}}", nameTags={"validateCPF"}, description="{{validateCPFDescription}}", params={"{{cpf}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var validateCPF(Var cpf) {
        if (Var.valueOf(cpf).isEmptyOrNull().booleanValue()) {
            return Var.VAR_FALSE;
        }
        return Operations.isValidCPF(Var.valueOf(cpf).toString());
    }

    @CronapiMetaData(type="function", name="{{validateCNPJ}}", nameTags={"validateCNPJ"}, description="{{validateCNPJDescription}}", params={"{{cnpj}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var validateCNPJ(Var cnpj) {
        if (Var.valueOf(cnpj).isEmptyOrNull().booleanValue()) {
            return Var.VAR_FALSE;
        }
        return Operations.isValidCNPJ(Var.valueOf(cnpj).toString());
    }

    @CronapiMetaData(type="function", name="{{validateEmail}}", nameTags={"validateEmail"}, description="{{validateEmailDescription}}", params={"{{email}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var validateEmail(Var email) throws Exception {
        return cronapi.regex.Operations.validateTextWithRegexUnscape(email, new Var("^[\\w\\.-]+@([\\w\\-]+\\.)+[A-Z]{2,4}$"), new Var("CASE_INSENSITIVE"));
    }

    private static final Var isValidCPF(String cpf) {
        int[] weightCPF = new int[]{11, 10, 9, 8, 7, 6, 5, 4, 3, 2};
        if ((cpf = cpf.trim().replace(".", "").replace("-", "")).length() != 11) {
            return Var.VAR_FALSE;
        }
        for (int j = 0; j < 10; ++j) {
            if (!Operations.padLeft(Integer.toString(j), Character.forDigit(j, 10)).equals(cpf)) continue;
            return Var.VAR_FALSE;
        }
        Integer digit1 = Operations.calculateDigit(cpf.substring(0, 9), weightCPF);
        Integer digit2 = Operations.calculateDigit(cpf.substring(0, 9) + digit1, weightCPF);
        Boolean result = cpf.equals(cpf.substring(0, 9) + digit1.toString() + digit2.toString());
        return Var.valueOf(result);
    }

    private static final Var isValidCNPJ(String cnpj) {
        int[] weightCNPJ = new int[]{6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        if ((cnpj = cnpj.trim().replace(".", "").replace("-", "").replace("/", "")).length() != 14) {
            return Var.VAR_FALSE;
        }
        Integer digit1 = Operations.calculateDigit(cnpj.substring(0, 12), weightCNPJ);
        Integer digit2 = Operations.calculateDigit(cnpj.substring(0, 12) + digit1, weightCNPJ);
        Boolean result = cnpj.equals(cnpj.substring(0, 12) + digit1.toString() + digit2.toString());
        return Var.valueOf(result);
    }

    private static final String padLeft(String text, char character) {
        return String.format("%11s", text).replace(' ', character);
    }

    private static int calculateDigit(String str, int[] weight) {
        int sum = 0;
        for (int index = str.length() - 1; index >= 0; --index) {
            int digit = Integer.parseInt(str.substring(index, index + 1));
            sum += digit * weight[weight.length - str.length() + index];
        }
        return (sum = 11 - sum % 11) > 9 ? 0 : sum;
    }
}

