/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import cronapi.CustomHttpClient;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.clazz.CronapiClassLoader;
import cronapi.database.TransactionManager;
import cronapi.i18n.AppMessages;
import cronapi.i18n.Messages;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CronapiFilter
implements Filter {
    public static ThreadLocal<HttpServletRequest> REQUEST = new ThreadLocal();
    public static ThreadLocal<HttpServletResponse> RESPONSE = new ThreadLocal();

    public void init(FilterConfig chain) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        REQUEST.set(request);
        RESPONSE.set(response);
        Messages.set(req.getLocale());
        AppMessages.set(req.getLocale());
        try {
            chain.doFilter(req, resp);
        }
        finally {
            RestClient.removeClient();
            REQUEST.set(null);
            REQUEST.remove();
            RESPONSE.set(null);
            RESPONSE.remove();
            Messages.remove();
            AppMessages.remove();
            TransactionManager.close();
            TransactionManager.clear();
            CronapiClassLoader.clear();
            QueryManager.JSON_CACHE.set(null);
            QueryManager.JSON_CACHE.remove();
            RestClient.getRestClient().cleanup();
        }
    }

    public void destroy() {
    }

    static {
        CustomHttpClient.acceptSSL();
    }
}

