/*
 * Decompiled with CFR 0.152.
 */
package cronapi.jdbc;

import cronapi.jdbc.DatabaseMetadata;
import cronapi.jdbc.SQLAnsiMetadata;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.First;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.jpa.processor.core.ExpressionProvider;
import org.apache.olingo.odata2.jpa.processor.core.ExpressionProviderFactory;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.FirebirdDictionary;
import org.apache.openjpa.lib.conf.Configuration;

public class FirebirdMetadata
extends SQLAnsiMetadata
implements DatabaseMetadata {
    private static final long FB_REPLACE_CODE = 9764555L;
    private static final FirebirdDictionary DICTIONARY = new FirebirdDictionary();

    @Override
    public String limit(Statement statement, Connection connection, Integer top, Integer skip) throws Exception {
        PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
        First first = new First().withKeyword(First.Keyword.FIRST).withRowCount(Long.valueOf(9764555L));
        select.setFirst(first);
        return statement.toString().replace("FIRST 9764555", "FIRST " + top + " SKIP " + skip);
    }

    @Override
    public String count(Statement statement, Connection connection) {
        PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
        select.setOrderByElements(List.of());
        String sql = "select count(*) AS CRONAPP_COUNT from (" + statement + ") as CRONAPP_COUNT_SELECT";
        return sql;
    }

    @Override
    public DBDictionary getDictionary(Connection connection) throws SQLException {
        return DICTIONARY;
    }

    @Override
    public Map<String, Object> getGenerated(EdmEntityType entity, PreparedStatement ps, Connection connection) throws Exception {
        ResultSet keys = ps.getGeneratedKeys();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (keys != null && keys.next()) {
            for (int c = 1; c <= keys.getMetaData().getColumnCount(); ++c) {
                map.put(keys.getMetaData().getColumnName(c), keys.getObject(c));
            }
        }
        return map;
    }

    @Override
    public ExpressionProvider getExpressionProvider() {
        return ExpressionProviderFactory.getProvider((String)"Firebird");
    }

    static {
        DICTIONARY.setConfiguration((Configuration)new JDBCConfigurationImpl());
    }
}

