/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import cronapi.Var;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.MessageInfo;

public class SOAPUtil {
    private static Map<String, Client> CACHE = new ConcurrentHashMap<String, Client>();
    private Client client;

    public ServiceMetadata getSOAPMetadata(String url, String name) {
        try {
            String cacheKey = "SOAP" + url;
            this.client = CACHE.get(cacheKey);
            if (this.client == null) {
                JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
                this.client = dcf.createClient(url);
                CACHE.put(cacheKey, this.client);
            }
            ServiceMetadata result = new ServiceMetadata();
            this.client.getEndpoint().getEndpointInfo().getService().getMessages().values().stream().forEach(message -> {
                if ((name == null || name.equals(message.getName().getLocalPart())) && message.getType() != MessageInfo.Type.OUTPUT) {
                    ServiceMetadataMethod method = new ServiceMetadataMethod((MessageInfo)message);
                    result.functions.add(method);
                }
            });
            result.functions.sort((f1, f2) -> f1.name.toLowerCase().compareTo(f2.name.toLowerCase()));
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object call(String method, Map<String, Var> headers, Object ... params) {
        try {
            TreeMap<String, List<String>> cxfHeaders = (TreeMap<String, List<String>>)this.client.getRequestContext().get(Message.PROTOCOL_HEADERS);
            if (cxfHeaders == null) {
                cxfHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                this.client.getRequestContext().put(Message.PROTOCOL_HEADERS, cxfHeaders);
            }
            for (Map.Entry<String, Var> entry : headers.entrySet()) {
                cxfHeaders.put(entry.getKey(), Collections.singletonList(entry.getValue().getObjectAsString()));
            }
            Object[] result = this.client.invoke(method, params);
            if (result != null && result.length > 0) {
                return result[0];
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static class ServiceMetadata {
        public List<ServiceMetadataMethod> functions = new LinkedList<ServiceMetadataMethod>();
    }

    public static class ServiceMetadataMethod {
        public Field[] inputs;
        public Field response;
        public String name;

        public ServiceMetadataMethod(MessageInfo message) {
            try {
                Class clazz = message.getFirstMessagePart().getTypeClass();
                this.inputs = clazz.getDeclaredFields();
                this.name = message.getOperation().getName().getLocalPart();
                MessageInfo responseMessage = message.getOperation().getOutput();
                if (responseMessage != null && responseMessage.getFirstMessagePart().getTypeClass().getDeclaredFields().length > 0) {
                    this.response = responseMessage.getFirstMessagePart().getTypeClass().getDeclaredFields()[0];
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

