/*
 * Decompiled with CFR 0.152.
 */
package cronapi.text;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Random;

@CronapiMetaData(category=CronapiMetaData.CategoryType.TEXT, categoryTags={"Text", "Texto"})
public class Operations {
    public static final Var newText(Var text) throws Exception {
        return new Var(text.getObjectAsString());
    }

    public static final Var newText(Var ... text) throws Exception {
        Var result = new Var("");
        for (Var t : text) {
            result.append(t.getObjectAsString());
        }
        return result;
    }

    public static final Var concat(Var item, Var ... itens) throws Exception {
        for (Var t : itens) {
            item.append(t.getObjectAsString());
        }
        return item;
    }

    public static final Var titleCase(Var text) {
        StringBuilder titleCase = new StringBuilder();
        boolean nextTitleCase = true;
        String input = text.getObjectAsString();
        for (char c : input.toCharArray()) {
            if (Character.isSpaceChar(c)) {
                nextTitleCase = true;
            } else if (nextTitleCase) {
                c = Character.toTitleCase(c);
                nextTitleCase = false;
            }
            titleCase.append(c);
        }
        return Var.valueOf(titleCase.toString());
    }

    public static final Var getLetter(Var text, Var index) throws Exception {
        if (text.getType().equals((Object)Var.Type.NULL)) {
            return Var.VAR_NULL;
        }
        return text.getObjectAsString().length() >= index.getObjectAsInt() ? (index.getObjectAsInt() < 1 ? new Var(Character.valueOf(text.getObjectAsString().charAt(0))) : new Var(Character.valueOf(text.getObjectAsString().charAt(index.getObjectAsInt() - 1)))) : new Var(Character.valueOf(text.getObjectAsString().charAt(text.getObjectAsString().length() - 1)));
    }

    public static final Var getLetterFromEnd(Var text, Var index) throws Exception {
        if (text.getType().equals((Object)Var.Type.NULL)) {
            return Var.VAR_NULL;
        }
        if (index.getObjectAsInt() <= 0) {
            return new Var(Character.valueOf(text.getObjectAsString().charAt(text.getObjectAsString().length() - 1)));
        }
        return text.getObjectAsString().length() - index.getObjectAsInt() > 0 ? new Var(Character.valueOf(text.getObjectAsString().charAt(text.getObjectAsString().length() - index.getObjectAsInt()))) : new Var(Character.valueOf(text.getObjectAsString().charAt(0)));
    }

    public static final Var getFirstLetter(Var text) throws Exception {
        return Operations.getLetter(text, Var.valueOf(1));
    }

    public static final Var getLastLetter(Var text) throws Exception {
        return Operations.getLetter(text, Var.valueOf(text.getObjectAsString().length()));
    }

    public static final Var getRandomLetter(Var text) throws Exception {
        int i = new Random().nextInt(text.getObjectAsString().length());
        if (i == 0) {
            ++i;
        }
        return Operations.getLetter(text, Var.valueOf(i));
    }

    public static final Var getLettersFromStartToFromStart(Var text, Var index1, Var index2) throws Exception {
        if (index1.getObjectAsInt() < 1) {
            index1 = new Var(1);
        }
        if (index2.getObjectAsInt() < 1) {
            index2 = new Var(1);
        }
        if (index1.getObjectAsInt() > text.getObjectAsString().length()) {
            index1 = new Var(text.getObjectAsString().length());
        }
        if (index2.getObjectAsInt() > text.getObjectAsString().length()) {
            index2 = new Var(text.getObjectAsString().length());
        }
        if (index1.getObjectAsInt() <= index2.getObjectAsInt()) {
            return new Var(text.getObjectAsString().substring(index1.getObjectAsInt() - 1, index2.getObjectAsInt()));
        }
        return new Var(text.getObjectAsString().substring(index2.getObjectAsInt() - 1, index1.getObjectAsInt()));
    }

    public static final Var getLettersFromStartToFromEnd(Var text, Var index1, Var index2) throws Exception {
        if (index1.getObjectAsInt() < 1) {
            index1 = new Var(1);
        }
        if (index2.getObjectAsInt() <= 1) {
            index2 = new Var(1);
        }
        if (index1.getObjectAsInt() > text.getObjectAsString().length()) {
            index1 = new Var(text.getObjectAsString().length());
        }
        if (index2.getObjectAsInt() > text.getObjectAsString().length()) {
            index2 = new Var(text.getObjectAsString().length());
        }
        if (index1.getObjectAsInt() <= text.getObjectAsString().length() - index2.getObjectAsInt()) {
            return new Var(text.getObjectAsString().substring(index1.getObjectAsInt() - 1, text.getObjectAsString().length() - (index2.getObjectAsInt() - 1)));
        }
        if (index1.getObjectAsInt() == 1 && index2.getObjectAsInt().intValue() == text.getObjectAsString().length()) {
            return new Var(text.getObjectAsString().substring(0, 1));
        }
        return Var.VAR_NULL;
    }

    public static final Var getLettersFromStartToLast(Var text, Var index1) throws Exception {
        if (index1.getObjectAsInt() < 1) {
            index1 = new Var(1);
        }
        if (index1.getObjectAsInt() > text.getObjectAsString().length()) {
            index1 = new Var(text.getObjectAsString().length() + 1);
        }
        return new Var(text.getObjectAsString().substring(index1.getObjectAsInt() - 1));
    }

    public static final Var getLettersFromEndToFromStart(Var text, Var index1, Var index2) throws Exception {
        if (index2.getObjectAsInt() < 1) {
            index2 = new Var(1);
        }
        if (index1.getObjectAsInt() < 1) {
            index1 = new Var(1);
        }
        if (index2.getObjectAsInt() >= text.getObjectAsString().length()) {
            index2 = new Var(text.getObjectAsString().length());
        }
        if (index1.getObjectAsInt() > text.getObjectAsString().length()) {
            index1 = new Var(text.getObjectAsString().length());
        }
        if (index2.getObjectAsInt() == 1 && text.length() - index1.getObjectAsInt() == 0) {
            return new Var(text.getObjectAsString().substring(0, 1));
        }
        if (text.length() - index1.getObjectAsInt() < index2.getObjectAsInt()) {
            return new Var(text.getObjectAsString().substring(text.length() - index1.getObjectAsInt(), index2.getObjectAsInt()));
        }
        return Var.VAR_NULL;
    }

    public static final Var getLettersFromEndToFromEnd(Var text, Var index1, Var index2) throws Exception {
        if (index2.getObjectAsInt() < 1) {
            index2 = new Var(1);
        }
        if (index1.getObjectAsInt() < 1) {
            index1 = new Var(1);
        }
        if (index2.getObjectAsInt() > text.getObjectAsString().length()) {
            index2 = new Var(text.getObjectAsString().length());
        }
        if (index1.getObjectAsInt() > text.getObjectAsString().length()) {
            index1 = new Var(text.getObjectAsString().length());
        }
        if (index1.getObjectAsInt() > index2.getObjectAsInt()) {
            return new Var(text.getObjectAsString().substring(text.length() - index1.getObjectAsInt(), text.length() - index2.getObjectAsInt() + 1));
        }
        if (index1.getObjectAsInt() == index2.getObjectAsInt()) {
            return new Var(text.getObjectAsString().substring(text.length() - index1.getObjectAsInt(), text.length() - (index1.getObjectAsInt() - 1)));
        }
        return Var.VAR_NULL;
    }

    public static final Var getLettersFromEndToFromLast(Var text, Var index1) throws Exception {
        if (text.getType().equals((Object)Var.Type.NULL) || text.getObjectAsString().length() < 1) {
            return Var.VAR_NULL;
        }
        if (index1.getObjectAsInt() < 1) {
            return new Var(Character.valueOf(text.getObjectAsString().charAt(text.getObjectAsString().length() - 1)));
        }
        if (index1.getObjectAsInt() > text.getObjectAsString().length()) {
            index1 = new Var(text.getObjectAsString().length() + 1);
            return text;
        }
        return new Var(text.getObjectAsString().substring(text.length() - index1.getObjectAsInt()));
    }

    public static final Var getLettersFromFirstToFromStart(Var text, Var index1) throws Exception {
        if (index1.getObjectAsInt() < 1) {
            index1 = new Var(1);
        }
        if (index1.getObjectAsInt() > text.getObjectAsString().length()) {
            index1 = new Var(text.getObjectAsString().length());
        }
        return new Var(text.getObjectAsString().substring(0, index1.getObjectAsInt()));
    }

    public static final Var getLettersFromFirstToFromEnd(Var text, Var index1) throws Exception {
        if (index1.getObjectAsInt() < 1) {
            index1 = new Var(1);
        }
        if (index1.getObjectAsInt() > text.getObjectAsString().length()) {
            return new Var(text.getObjectAsString().substring(0, 1));
        }
        return new Var(text.getObjectAsString().substring(0, text.length() - (index1.getObjectAsInt() - 1)));
    }

    public static final Var getLettersFromFirstToEnd(Var text) throws Exception {
        return new Var(text.getObjectAsString());
    }

    @CronapiMetaData(type="function", name="{{newline}}", nameTags={"newline", "nova linha"}, description="{{newlineDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var newline() {
        return Var.valueOf("\n");
    }

    @CronapiMetaData(type="function", name="{{textReplaceFunction}}", nameTags={"replace", "substituir"}, description="{{textReplaceDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var replace(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textReplace}}", defaultValue="Site is crxnapp.ix") Var textReplace, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textReplaceTarget}}", defaultValue="x") Var target, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textReplaceReplacement}}", defaultValue="o") Var replacement) {
        if (target.isEmptyOrNull().booleanValue()) {
            return Var.valueOf(textReplace.getObjectAsString().trim());
        }
        return Var.valueOf(textReplace.getObjectAsString().replace(target.getObjectAsString(), replacement.getObjectAsString()).trim());
    }

    @CronapiMetaData(type="function", name="{{textReplaceAllFunction}}", nameTags={"replace", "substituir"}, description="{{textReplaceAllDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var replaceAll(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textReplace}}", defaultValue="My .com site is cronapp.com") Var textReplace, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textReplaceRegex}}", defaultValue="com") Var regex, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textReplaceReplacement}}", defaultValue="io") Var replacement) {
        return Var.valueOf(textReplace.getObjectAsString().replaceAll(regex.getObjectAsString(), replacement.getObjectAsString()).trim());
    }

    @CronapiMetaData(type="function", name="{{textReplaceFirstFunction}}", nameTags={"replace", "substituir"}, description="{{textReplaceFirstDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var replaceFirst(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textReplace}}", defaultValue="Site is Test.com") Var textReplace, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textReplaceRegex}}", defaultValue="Test(.*)") Var regex, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textReplaceReplacement}}", defaultValue="cronapp.io") Var replacement) {
        return Var.valueOf(textReplace.getObjectAsString().replaceFirst(regex.getObjectAsString(), replacement.getObjectAsString()).trim());
    }

    @CronapiMetaData(name="{{textNormalizeFunction}}", nameTags={"normalize", "normalizar"}, description="{{textNormalizeDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var normalize(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{nonNormalizedText}}") Var nonNormalizedText) {
        String normalizedText = Normalizer.normalize(nonNormalizedText.getObjectAsString(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").toLowerCase();
        return Var.valueOf(normalizedText);
    }

    @CronapiMetaData(name="{{textStartsWithFunction}}", nameTags={"startsWith", "come\u00e7a com"}, description="{{textStartsWithDescription}}", returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var startsWith(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textStarts}}") Var textStarts, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{prefixStartsWith}}") Var prefixStartsWith) {
        return Var.valueOf(textStarts.getObjectAsString().startsWith(prefixStartsWith.getObjectAsString()));
    }

    @CronapiMetaData(type="function", name="{{toSupplyText}}", nameTags={"substituir", "trocar"}, description="{{toSupplyTextDescription}}", arbitraryParams=true, returnType=CronapiMetaData.ObjectType.STRING)
    public static Var formatTextWithReplacement(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{toSupplyTextParam0}}") Var text, Var ... terms) {
        String textToReplace = text.getObjectAsString();
        ArrayList<Object> listTerms = new ArrayList<Object>();
        for (Var term : terms) {
            if (term.getObject() instanceof GregorianCalendar) {
                listTerms.add(term.getObjectAsDateTime().getTime());
                continue;
            }
            listTerms.add(term.getObject());
        }
        return Var.valueOf(MessageFormat.format(textToReplace, listTerms.toArray()));
    }
}

