/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronapp.acesso;

import api.entity.Autenticacao;
import api.entity.TokenDTO;
import api.entity.Usuario;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import util.PropertiesBean;

public class AcessoService {
    private PropertiesBean properties;
    private String LOGIN_URL;
    private String LOGOUT_URL;
    private String VALIDA_URL;
    private String UAATOKEN_URL;
    private String USERINFO;

    public AcessoService(String propertiesFile) {
        this(new PropertiesBean(propertiesFile));
    }

    public AcessoService(String acessoUrl, String cfAdminUser, String cfAdminPassword) {
        this.properties = new PropertiesBean(acessoUrl, cfAdminUser, cfAdminPassword);
        this.load(this.properties);
    }

    public AcessoService(PropertiesBean _properties) {
        this.load(_properties);
    }

    public void load(PropertiesBean _properties) {
        this.properties = _properties;
        this.LOGIN_URL = PropertiesBean.ACESSO_URL + "/api/rest/io/cronapp/Usuario/login";
        this.LOGOUT_URL = PropertiesBean.ACESSO_URL + "/api/rest/io/cronapp/Usuario/logout";
        this.VALIDA_URL = PropertiesBean.ACESSO_URL + "/api/rest/io/cronapp/Usuario/token/validar";
        this.UAATOKEN_URL = PropertiesBean.ACESSO_URL + "/api/rest/io/cronapp/Usuario/uaa/token";
        this.USERINFO = PropertiesBean.ACESSO_URL + "/api/rest/io/cronapp/oauth2/userinfo";
    }

    private void validate(String usuario, String senha) throws Exception {
        if (usuario == null || senha == null || usuario.isEmpty() || senha.isEmpty()) {
            throw new Exception("Usuario ou senha inv\u00e1lidos");
        }
    }

    public TokenDTO validaToken(String token) {
        WebTarget target = ClientBuilder.newClient().target(UriBuilder.fromUri((String)this.VALIDA_URL));
        Object[] objectArray = new Object[1];
        objectArray[0] = PropertiesBean.CF_ADMIN_USER;
        Object[] objectArray2 = new Object[1];
        objectArray2[0] = PropertiesBean.CF_ADMIN_PASSWORD;
        Response response = target.queryParam("admin", objectArray).queryParam("senha", objectArray2).queryParam("token", new Object[]{token}).request().get();
        return (TokenDTO)response.readEntity(TokenDTO.class);
    }

    public String getUaaToken(String token) {
        WebTarget target = ClientBuilder.newClient().target(UriBuilder.fromUri((String)this.UAATOKEN_URL));
        Response response = target.queryParam("cronappTk", new Object[]{token}).request().get();
        MultivaluedMap headers = response.getStringHeaders();
        String uaaToken = (String)headers.getFirst((Object)"UAATk");
        if (uaaToken == null) {
            throw new RuntimeException("Token Inv\u00e1lido. Msg:" + response);
        }
        return uaaToken;
    }

    public Autenticacao login(Usuario usuario) throws Exception {
        String cronAppTk = this.getToken(usuario);
        String cadastroTk = Autenticacao.secret(usuario.getUsername() + cronAppTk);
        return new Autenticacao(usuario.getUsername(), cronAppTk, cadastroTk);
    }

    public String getToken(String username, String senha) throws Exception {
        this.validate(username, senha);
        Usuario auth = new Usuario(username, senha);
        return this.getToken(auth);
    }

    public String getToken(Usuario usuario) throws Exception {
        WebTarget target = ClientBuilder.newClient().target(UriBuilder.fromUri((String)this.LOGIN_URL));
        Response response = (Response)target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)usuario), Response.class);
        MultivaluedMap headers = response.getStringHeaders();
        String token = (String)headers.getFirst((Object)"CronAppTk");
        if (token == null) {
            throw new Exception("Usuario/senha inv\u00e1lido(s). Msg:" + response);
        }
        return token;
    }

    public void logout(String usuario, String token) throws Exception {
        Usuario _u = new Usuario();
        _u.setUsername(usuario);
        WebTarget target = ClientBuilder.newClient().target(UriBuilder.fromUri((String)this.LOGOUT_URL));
        Response response = target.request().header("CronAppTk", (Object)token).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)_u));
        String output = (String)response.readEntity(String.class);
        System.out.println("o:" + output + "/ " + response.getStatus());
        if (response.getStatus() >= 400) {
            throw new Exception("Requisi\u00e7\u00e3o inv\u00e1lida.");
        }
    }

    public String getUserInfo(String cronAppTk) throws Exception {
        WebTarget target = ClientBuilder.newClient().target(UriBuilder.fromUri((String)this.USERINFO));
        Response response = target.queryParam("access_token", new Object[]{cronAppTk}).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        String output = (String)response.readEntity(String.class);
        if (output == null) {
            throw new Exception("TokenInvalido. Msg:" + response);
        }
        return output;
    }

    public JsonObject getPayloadTokenUAA(String uaaToken) {
        String[] jwtParts = uaaToken.split("\\.");
        JsonObject jwtHeader = Json.createReader((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(jwtParts[0]))).readObject();
        JsonObject jwtPayload = Json.createReader((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(jwtParts[1]))).readObject();
        return jwtPayload;
    }
}

