/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractGenerateFiles
extends AbstractMojo {
    public static String STATIC_OUTPUT_FOLDER = "/generated-resources/cronapp/static";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="forStatic", readonly=true, defaultValue="false")
    protected Boolean forStatic;
    @Parameter(defaultValue="${project.build.directory}")
    private File target;
    @Parameter(property="layer", required=false, defaultValue="all")
    private String layer;
    @Parameter(property="mobileapp", defaultValue="false")
    private Boolean mobileApp;
    @Parameter(property="serveDirect", defaultValue="false")
    private Boolean serveDirect;

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public String getLayer() {
        this.layer = System.getProperty("cronapp.layer", this.layer);
        return this.layer;
    }

    public boolean isMobileApp() {
        this.mobileApp = BooleanUtils.toBoolean((Boolean)"true".equalsIgnoreCase(System.getProperty("cronapp.mobileapp", this.mobileApp.toString())));
        return this.mobileApp;
    }

    public boolean isServeDirect() {
        this.serveDirect = BooleanUtils.toBoolean((Boolean)"true".equalsIgnoreCase(System.getProperty("cronapp.serveDirect", this.serveDirect.toString())));
        return this.serveDirect;
    }

    public File getServeDirectFolder() {
        return new File(this.getTarget(), "tomcat");
    }

    public File getExplodedFolder() {
        return new File(this.getTarget(), this.forStatic != false ? "" : this.getMavenProject().getBuild().getFinalName());
    }

    public String getMobileDestinationFolder() {
        return Boolean.TRUE.equals(this.isServeDirect()) ? "mobileapp" + File.separator + "www" : "mobileapp";
    }

    public File getProjectMain() {
        return new File(this.getMavenProject().getBasedir(), "src/main");
    }

    public File getWebProject() {
        return new File(this.getProjectMain(), "webapp");
    }

    public File getMobileProject() {
        return new File(this.getProjectMain(), "mobileapp/www");
    }

    public boolean hasLayerAll() {
        return "all".equalsIgnoreCase(this.getLayer());
    }

    public boolean hasLayerMobile() {
        return this.isMobileApp() || this.hasLayerAll() || "mobile".equalsIgnoreCase(this.getLayer());
    }

    public boolean hasLayerWeb() {
        String selectedLayer = this.getLayer();
        return this.hasLayerAll() || "web".equalsIgnoreCase(selectedLayer) || StringUtils.isBlank((CharSequence)selectedLayer);
    }

    public File getMetaInfDirectory() {
        File metaInf = new File(this.getMavenProject().getBasedir(), "src/main/java/META-INF");
        if (!metaInf.exists()) {
            metaInf = new File(this.getMavenProject().getBasedir(), "src/META-INF");
        }
        return metaInf;
    }

    public void createFileForMobile(String content, String filename) throws IOException {
        if (this.getMobileProject().exists() && this.hasLayerMobile()) {
            if (this.isServeDirect()) {
                this.save(this.getServeDirectFolder(), content, this.getMobileDestinationFolder() + filename);
            } else {
                this.save(this.getExplodedFolder(), content, this.getMobileDestinationFolder() + filename);
            }
        }
    }

    public void createFileForWeb(String content, String filename) throws IOException {
        if (this.getWebProject().exists() && this.hasLayerWeb()) {
            if (this.isServeDirect()) {
                this.save(this.getServeDirectFolder(), content, "webapp" + filename);
            } else {
                this.save(this.getExplodedFolder(), content, filename);
            }
        }
    }

    public File getMobileFile(String filename) {
        if (this.isServeDirect()) {
            return new File(this.getServeDirectFolder(), this.getMobileDestinationFolder() + filename);
        }
        return new File(this.getExplodedFolder(), this.getMobileDestinationFolder() + filename);
    }

    public File getWebFile(String filename) {
        if (this.isServeDirect()) {
            return new File(this.getServeDirectFolder(), "webapp" + filename);
        }
        return new File(this.getExplodedFolder(), filename);
    }

    public void setForStatic(Boolean forStatic) {
        this.forStatic = forStatic;
    }

    public Boolean getForStatic() {
        return this.forStatic;
    }

    private void save(File parentFolder, String contentFile, String filename) throws IOException {
        File file = new File(parentFolder, filename);
        file.getParentFile().mkdirs();
        FileUtils.write((File)file, (CharSequence)contentFile, (Charset)StandardCharsets.UTF_8);
    }
}

