/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.cronapp.xml.Parameter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContextManager {
    private static final String DEV = "DEV";
    private static final String PROD = "PROD";
    private Document doc;

    public ContextManager(InputStream stream) {
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateProfile(String activeProfile) {
        ArrayList<Node> allNodes = new ArrayList<Node>(this.doc.getDocumentElement().getChildNodes().getLength());
        ArrayList<Node> removeNodes = new ArrayList<Node>(this.doc.getDocumentElement().getChildNodes().getLength());
        for (int i = 0; i < this.doc.getDocumentElement().getChildNodes().getLength(); ++i) {
            if (this.doc.getDocumentElement().getChildNodes().item(i) instanceof Element) {
                allNodes.add(this.doc.getDocumentElement().getChildNodes().item(i));
            }
            removeNodes.add(this.doc.getDocumentElement().getChildNodes().item(i));
        }
        for (Node node : removeNodes) {
            this.doc.getDocumentElement().removeChild(node);
        }
        Collections.sort(allNodes, (o1, o2) -> {
            if (o1 instanceof Element && o2 instanceof Element) {
                String profile1 = ((Element)o1).getAttribute("profile");
                String profile2 = ((Element)o2).getAttribute("profile");
                String tag1 = ((Element)o1).getTagName();
                String tag2 = ((Element)o2).getTagName();
                int score1 = 0;
                int score2 = 0;
                if ("resource".equalsIgnoreCase(tag1)) {
                    ++score1;
                }
                if ("resource".equalsIgnoreCase(tag2)) {
                    ++score2;
                }
                if (activeProfile.equalsIgnoreCase(profile1)) {
                    ++score1;
                }
                if (activeProfile.equalsIgnoreCase(profile2)) {
                    ++score2;
                }
                return Integer.compare(score2, score1);
            }
            return 0;
        });
        for (Node node : allNodes) {
            this.doc.getDocumentElement().appendChild(node);
        }
    }

    public void cleanDuplicated() {
        ArrayList<Node> allNodes = new ArrayList<Node>(this.doc.getDocumentElement().getChildNodes().getLength());
        for (int i = 0; i < this.doc.getDocumentElement().getChildNodes().getLength(); ++i) {
            Node node = this.doc.getDocumentElement().getChildNodes().item(i);
            allNodes.add(node);
        }
        HashSet<String> ids = new HashSet<String>();
        for (Node node : allNodes) {
            if (!(node instanceof Element)) continue;
            if (((Element)node).getTagName().equalsIgnoreCase("Profile")) {
                this.doc.getDocumentElement().removeChild(node);
                continue;
            }
            String name = ((Element)node).getAttribute("name");
            if (ids.contains(name)) {
                this.doc.getDocumentElement().removeChild(node);
                continue;
            }
            ids.add(name);
            if (!((Element)node).hasAttribute("profile")) continue;
            ((Element)node).removeAttribute("profile");
        }
    }

    public void createOrReplaceParameter(Parameter parameter, String originalName) throws Exception {
        String xpathResource = String.format("//Parameter[@name='%s']", originalName);
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate(xpathResource, this.doc, XPathConstants.NODESET);
        if (nodes != null && nodes.getLength() > 0) {
            Node node = nodes.item(0);
            NamedNodeMap attr = node.getAttributes();
            attr.getNamedItem("name").setTextContent(parameter.getName());
            attr.getNamedItem("value").setTextContent(parameter.getValue());
        } else {
            Element node = this.doc.getDocumentElement();
            Element newelement = this.doc.createElement("Parameter");
            newelement.setAttribute("name", parameter.getName());
            newelement.setAttribute("value", parameter.getValue());
            if (!StringUtils.isEmpty((CharSequence)parameter.getProfile())) {
                newelement.setAttribute("profile", parameter.getProfile());
            }
            node.appendChild(newelement);
        }
    }

    public static Document removeEmptyLines(Document doc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nl = (NodeList)xpath.evaluate("//text()[normalize-space(.)='']", doc, XPathConstants.NODESET);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            node.getParentNode().removeChild(node);
        }
        return doc;
    }

    public static void toPath(Document doc, Path file) throws TransformerException, XPathExpressionException, IOException {
        doc = ContextManager.removeEmptyLines(doc);
        DOMSource domSource = new DOMSource(doc);
        if (Files.exists(file, new LinkOption[0])) {
            Files.delete(file);
        }
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            StreamResult xmlResult = new StreamResult(out);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(domSource, xmlResult);
        }
    }

    public void saveTo(Path file) {
        try {
            ContextManager.toPath(this.doc, file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanDatasources() {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate("//Resource", this.doc, XPathConstants.NODESET);
            if (nodes != null && nodes.getLength() > 0) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    node.getParentNode().removeChild(node);
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

