/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.cronapp.ContextManager;
import io.cronapp.persistence.PersistenceManager;
import io.cronapp.persistence.model.Persistence;
import io.cronapp.xml.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="compile", defaultPhase=LifecyclePhase.PACKAGE)
public class CronappCompileMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @org.apache.maven.plugins.annotations.Parameter(property="populate", defaultValue="true")
    private String populateParam;
    private boolean populate;
    @org.apache.maven.plugins.annotations.Parameter(property="profile", defaultValue="")
    private String profile;
    @org.apache.maven.plugins.annotations.Parameter(property="generationType", defaultValue="auto")
    private String generationType;
    @org.apache.maven.plugins.annotations.Parameter(property="useContext", defaultValue="true")
    private String useContextParam;
    private boolean useContext;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Starting Cronapp Compile Plugin");
        this.populate = System.getProperty("cronapp.populate", this.populateParam).equals("true");
        this.profile = System.getProperty("cronapp.profile", this.profile);
        this.generationType = System.getProperty("cronapp.generationType", this.generationType);
        this.useContext = System.getProperty("cronapp.useContext", this.useContextParam).equals("true");
        File targetFolder = new File(this.mavenProject.getBuild().getDirectory());
        File jarFile = new File(targetFolder, this.mavenProject.getBuild().getFinalName() + ".war");
        File explodedFolder = new File(targetFolder, this.mavenProject.getBuild().getFinalName());
        try {
            URI zipURI = new URI("jar", jarFile.toURI().toString(), null);
            HashMap<String, String> zipProperties = new HashMap<String, String>();
            zipProperties.put("create", "false");
            try (FileSystem zipFS = FileSystems.newFileSystem(zipURI, zipProperties);){
                Path context = zipFS.getPath("META-INF/context.xml", new String[0]);
                this.handleContext(context);
                if (!this.generationType.equals("auto")) {
                    Path persistencePath = zipFS.getPath("WEB-INF/classes/META-INF/persistence.xml", new String[0]);
                    this.handleGenerationType(persistencePath);
                }
                if (!this.populate) {
                    Path root = zipFS.getPath("WEB-INF/classes/", new String[0]);
                    this.handlePopulate(root);
                }
            }
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        try {
            if (explodedFolder.exists()) {
                Path context = new File(explodedFolder, "META-INF/context.xml").toPath();
                this.handleContext(context);
                if (!this.generationType.equals("auto")) {
                    Path persistencePath = new File(explodedFolder, "WEB-INF/classes/META-INF/persistence.xml").toPath();
                    this.handleGenerationType(persistencePath);
                }
                if (!this.populate) {
                    Path root = new File(explodedFolder, "WEB-INF/classes/").toPath();
                    this.handlePopulate(root);
                }
            }
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void handleContext(Path context) throws Exception {
        if (Files.exists(context, new LinkOption[0]) && context != null) {
            ContextManager contextManager;
            try (InputStream in = Files.newInputStream(context, new OpenOption[0]);){
                contextManager = new ContextManager(in);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.profile)) {
                this.getLog().info((CharSequence)("Setting profile " + this.profile));
                contextManager.updateProfile(this.profile);
                contextManager.createOrReplaceParameter(new Parameter("app.profile", this.profile), "app.profile");
            }
            this.getLog().info((CharSequence)"Cleaning up context.xml");
            contextManager.cleanDuplicated();
            if (!this.useContext) {
                this.getLog().info((CharSequence)"Cleaning up datasources");
                contextManager.cleanDatasources();
            }
            contextManager.saveTo(context);
        }
    }

    private void handleGenerationType(Path persistencePath) throws Exception {
        if (Files.exists(persistencePath, new LinkOption[0])) {
            Persistence persistence;
            PersistenceManager persistenceManager = new PersistenceManager();
            try (InputStream in = Files.newInputStream(persistencePath, new OpenOption[0]);){
                persistence = persistenceManager.getPersistence(in);
            }
            this.getLog().info((CharSequence)("Setting generationType to " + this.generationType));
            persistenceManager.setGenerationType(persistence, this.generationType);
            persistenceManager.saveAs(persistence, persistencePath);
        }
    }

    private void handlePopulate(Path root) throws IOException {
        Files.find(root, Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.toString().endsWith("populate.json"), new FileVisitOption[0]).forEach(path -> {
            try {
                this.getLog().info((CharSequence)("Removing " + path));
                Files.delete(path);
            }
            catch (IOException e1) {
                this.getLog().error((Throwable)e1);
            }
        });
    }
}

