/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import com.google.gson.Gson;
import io.cronapp.AbstractGenerateFiles;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="generate-cacheable-resources", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateCacheableResourcesMojo
extends AbstractGenerateFiles {
    public void execute() {
        if (this.getForStatic().booleanValue()) {
            this.setTarget(new File(this.getTarget().getAbsolutePath() + AbstractGenerateFiles.STATIC_OUTPUT_FOLDER));
        }
        this.getLog().info((CharSequence)"Starting generate-cacheable-resources Goal");
        if (this.getMavenProject() != null) {
            try {
                String cacheableResourcesFilename = "/js/cacheableResources.json";
                String blocklyJsFileName = "/js/blockly.js";
                File mobileProject = this.getMobileProject();
                File webProject = this.getWebProject();
                if (mobileProject.exists() && new File(this.getMobileProject(), "index.html").exists()) {
                    File mobileBlocklyJsFile = this.getMobileFile(blocklyJsFileName);
                    String mobileCacheableResourceJson = this.getCacheableResourceFileContent(mobileProject, mobileBlocklyJsFile);
                    this.createFileForMobile(mobileCacheableResourceJson, cacheableResourcesFilename);
                }
                if (webProject.exists() && new File(this.getWebProject(), "index.html").exists()) {
                    File webBlocklyJsFile = this.getWebFile(blocklyJsFileName);
                    String webCacheableResourceJson = this.getCacheableResourceFileContent(webProject, webBlocklyJsFile);
                    this.createFileForWeb(webCacheableResourceJson, cacheableResourcesFilename);
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Could not save cacheableResources.json file", (Throwable)e);
            }
            this.getLog().info((CharSequence)"Goal generate-cacheable-resources finished");
        } else {
            this.getLog().error((CharSequence)"Maven project was not found");
        }
    }

    private String getCacheableResourceFileContent(File sourceFolder, File blocklyJsFile) {
        String[] extensionsToCache = new String[]{"html", "svg", "jpg", "jpeg", "png", "json", "css", "ttf", "woff"};
        ArrayList<String> cacheableResources = new ArrayList<String>();
        FileUtils.listFiles((File)sourceFolder, (String[])extensionsToCache, (boolean)true).forEach(file -> cacheableResources.add(file.getPath().replace(sourceFolder.getPath(), ".")));
        File indexResource = new File(sourceFolder, "index.html");
        cacheableResources.addAll(this.getDependenciesAsJsonArray(indexResource, "link.*href=[\"'](.*?)[\"']"));
        cacheableResources.addAll(this.getDependenciesAsJsonArray(indexResource, "script.*src=[\"'](.*?)[\"']"));
        if (blocklyJsFile != null && blocklyJsFile.exists()) {
            cacheableResources.addAll(this.getDependenciesAsJsonArray(blocklyJsFile, "script.*src=[\"'](.*?)[\"']"));
        }
        return new Gson().toJson(cacheableResources);
    }

    private ArrayList<String> getDependenciesAsJsonArray(File targetResource, String regex) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            if (targetResource != null) {
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(Files.readString(targetResource.toPath()));
                while (m.find()) {
                    result.add(m.group(1));
                }
            }
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
        }
        return result;
    }
}

