/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.cronapp.AbstractGenerateFiles;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-host-app", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateHostApp
extends AbstractGenerateFiles {
    @Parameter(property="hostApp")
    protected String hostApp;

    public void execute() {
        if (this.getForStatic().booleanValue()) {
            this.setTarget(new File(this.getTarget().getAbsolutePath() + AbstractGenerateFiles.STATIC_OUTPUT_FOLDER));
        }
        this.hostApp = System.getProperty("cronapp.hostApp", this.hostApp);
        if (StringUtils.isNotBlank((CharSequence)this.hostApp)) {
            if (!this.hostApp.endsWith("/")) {
                this.hostApp = this.hostApp + "/";
            }
            this.getLog().info((CharSequence)"Starting generate-host-app Goal");
            if (this.getMavenProject() != null) {
                try {
                    String hostAppJsFile = "/js/hostApp.js";
                    String hostAppJsContent = "window.hostApp = '" + this.hostApp + "';";
                    this.createFileForMobile(hostAppJsContent, hostAppJsFile);
                    this.createFileForWeb(hostAppJsContent, hostAppJsFile);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"Could not save hostApp.js file", (Throwable)e);
                }
                this.getLog().info((CharSequence)"Goal generate-host-app finished");
            } else {
                this.getLog().error((CharSequence)"Maven project was not found");
            }
        }
    }
}

