/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.cronapp.AbstractGenerateFiles;
import io.cronapp.extensions.GenerateFilesExtensions;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="generate-system-events", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateSystemEventsJsMojo
extends AbstractGenerateFiles {
    public void execute() {
        this.getLog().info((CharSequence)"Starting generate-system-events Goal");
        if (this.getForStatic().booleanValue()) {
            this.setTarget(new File(this.getTarget().getAbsolutePath() + AbstractGenerateFiles.STATIC_OUTPUT_FOLDER));
        }
        if (this.getMavenProject() != null) {
            try {
                String systemEventsJsMobileFile = "/js/events.js";
                String systemEventsJsFile = "/js/system-events.js";
                String systemEventsJsContent = this.getEventJsContent();
                this.createFileForMobile(systemEventsJsContent, systemEventsJsMobileFile);
                this.createFileForWeb(systemEventsJsContent, systemEventsJsFile);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Could not save system-events.js file", (Throwable)e);
            }
            this.getLog().info((CharSequence)"Goal generate-system-events finished");
        } else {
            this.getLog().error((CharSequence)"Maven project was not found");
        }
    }

    private JsonObject getEventsJsonFile() {
        try {
            JsonElement eventsJsonFile = new JsonParser().parse((Reader)new FileReader(new File(this.getMetaInfDirectory(), "events.json")));
            return eventsJsonFile.getAsJsonObject();
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    private String getEventJsContent() {
        JsonObject eventsJsFile = this.getEventsJsonFile();
        StringBuilder eventsJsContent = new StringBuilder().append("window.blockly = window.blockly || {};").append("window.blockly.events = window.blockly.events || {};");
        for (Map.Entry entry : eventsJsFile.entrySet()) {
            JsonObject customObj;
            if (GenerateFilesExtensions.isNull((JsonElement)entry.getValue()).booleanValue() || GenerateFilesExtensions.isNull((customObj = ((JsonElement)entry.getValue()).getAsJsonObject()).get("type")).booleanValue() || !customObj.get("type").getAsString().equals("client")) continue;
            this.write(eventsJsContent, (String)entry.getKey(), customObj);
        }
        return eventsJsContent.toString();
    }

    private void write(StringBuilder eventsJsContent, String eventName, JsonObject eventObj) {
        String namespace = "window.blockly.events." + eventName;
        eventsJsContent.append("try{ ");
        eventsJsContent.append(namespace);
        if (!GenerateFilesExtensions.isNull(eventObj.get("blockly")).booleanValue()) {
            String blocklyNamespace = eventObj.get("blockly").getAsJsonObject().get("namespace").getAsString();
            String method = GenerateFilesExtensions.safeNameForMethodBlockly(eventObj.get("blocklyMethod").getAsString());
            eventsJsContent.append(" = blockly.").append(blocklyNamespace).append(".").append(method).append(";");
            eventsJsContent.append(" } catch(ex){ ");
            eventsJsContent.append(namespace).append(" = 'blockly.").append(blocklyNamespace).append(".").append(method).append("';");
            eventsJsContent.append(" }");
        } else {
            eventsJsContent.append(" = {}; } catch(ex){ }");
        }
    }
}

