/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.HashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="package-listener", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageListenerMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Parameter(property="mobileapp", defaultValue="false")
    protected Boolean mobileApp;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.mobileApp = BooleanUtils.toBoolean((Boolean)System.getProperty("cronapp.mobileapp", this.mobileApp.toString()).equals("true"));
        if (this.mobileApp.booleanValue()) {
            File targetFolder = new File(this.mavenProject.getBuild().getDirectory());
            File jarFile = new File(targetFolder, this.mavenProject.getBuild().getFinalName() + ".war");
            try {
                URI zipURI = new URI("jar", jarFile.toURI().toString(), null);
                HashMap<String, String> zipProperties = new HashMap<String, String>();
                zipProperties.put("create", "false");
                try (FileSystem zipFS = FileSystems.newFileSystem(zipURI, zipProperties);){
                    Path root = zipFS.getPath("/", new String[0]);
                    this.handleMobileapp(root);
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private void handleMobileapp(Path root) throws IOException {
        Path source = this.mavenProject.getBasedir().toPath().resolve("src").resolve("main").resolve("mobileapp").resolve("www");
        if (!Files.exists(source, new LinkOption[0])) {
            return;
        }
        Path target = root.resolve("mobileapp");
        this.getLog().info((CharSequence)("Including " + source));
        this.copyFolder(source, target, StandardCopyOption.REPLACE_EXISTING);
    }

    public void copyFolder(final Path source, final Path target, final CopyOption ... options) throws IOException {
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(target.resolve(source.relativize(dir).toString()), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(source.relativize(file).toString()), options);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

