/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.cronapp.persistence.PersistenceManager;
import io.cronapp.persistence.model.Persistence;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="process-persistence-xml", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ProcessPersistenceXmlMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="generationType", defaultValue="auto")
    protected String generationType;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.generationType.equals("auto")) {
            return;
        }
        this.generationType = System.getProperty("cronapp.generationType", this.generationType);
        Path persistencePath = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]).resolve("META-INF").resolve("persistence.xml");
        if (!Files.exists(persistencePath, new LinkOption[0])) {
            return;
        }
        try {
            Persistence persistence;
            PersistenceManager persistenceManager = new PersistenceManager();
            try (InputStream inputStream = Files.newInputStream(persistencePath, new OpenOption[0]);){
                persistence = persistenceManager.getPersistence(inputStream);
            }
            this.getLog().info((CharSequence)("Setting generationType to " + this.generationType));
            persistenceManager.setGenerationType(persistence, this.generationType);
            persistenceManager.saveAs(persistence, persistencePath);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

