/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="process-populate-json", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ProcessPopulateJsonMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="populate", defaultValue="true")
    protected Boolean populate;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.populate.booleanValue()) {
            return;
        }
        this.populate = BooleanUtils.toBoolean((Boolean)System.getProperty("cronapp.populate", this.populate.toString()).equals("true"));
        Path root = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
        try {
            Files.find(root, Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.toString().endsWith("populate.json"), new FileVisitOption[0]).forEach(path -> {
                try {
                    this.getLog().info((CharSequence)("Removing " + path));
                    Files.delete(path);
                }
                catch (IOException e1) {
                    this.getLog().error((Throwable)e1);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

