/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.persistence;

import io.cronapp.persistence.model.Persistence;
import io.cronapp.xml.NamespaceFilterXMLReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.InputSource;

public class PersistenceManager {
    public Persistence getPersistence(InputStream stream) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Persistence.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            NamespaceFilterXMLReader reader = new NamespaceFilterXMLReader();
            InputSource is = new InputSource(stream);
            SAXSource ss = new SAXSource(reader, is);
            return (Persistence)unmarshaller.unmarshal((Source)ss);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Persistence.PersistenceUnit getPersistenceUnitByName(Persistence persistence, String name) {
        for (Persistence.PersistenceUnit pu : persistence.getPersistenceUnit()) {
            if (!pu.getName().equals(name)) continue;
            return pu;
        }
        return null;
    }

    private void addProperty(Persistence.PersistenceUnit persistenceUnit, String key, String value) {
        Persistence.PersistenceUnit.Properties.Property oldProperty = this.getProperty(persistenceUnit, key);
        if (oldProperty != null) {
            oldProperty.setValue(value);
        } else {
            Persistence.PersistenceUnit.Properties.Property property = new Persistence.PersistenceUnit.Properties.Property();
            property.setName(key);
            property.setValue(value);
            persistenceUnit.getProperties().getProperty().add(property);
        }
    }

    public Persistence.PersistenceUnit.Properties.Property getProperty(Persistence.PersistenceUnit persistenceUnit, String key) {
        for (Persistence.PersistenceUnit.Properties.Property p : persistenceUnit.getProperties().getProperty()) {
            if (!p.getName().equals(key)) continue;
            return p;
        }
        return null;
    }

    public void setGenerationType(Persistence persistence, String type) {
        if (StringUtils.isEmpty((CharSequence)type) || type.equalsIgnoreCase("auto")) {
            return;
        }
        for (Persistence.PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
            if (persistenceUnit.getProperties().getProperty() == null) continue;
            boolean found = false;
            for (Persistence.PersistenceUnit.Properties.Property property : persistenceUnit.getProperties().getProperty()) {
                if (!property.getName().equals("eclipselink.ddl-generation")) continue;
                property.setValue(type);
                found = true;
            }
            if (found) continue;
            Persistence.PersistenceUnit.Properties.Property property = new Persistence.PersistenceUnit.Properties.Property();
            property.setName("eclipselink.ddl-generation");
            property.setValue(type);
            persistenceUnit.getProperties().getProperty().add(property);
        }
    }

    public void saveAs(Persistence persistence, File file) throws Exception {
        FileWriter xml = new FileWriter(file);
        JAXB.marshal((Object)persistence, (Writer)xml);
    }

    public void saveAs(Persistence persistence, Path file) throws Exception {
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);
             OutputStreamWriter xml = new OutputStreamWriter(out);){
            JAXB.marshal((Object)persistence, (Writer)xml);
        }
    }
}

