/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.cronapp.extensions.MojoExecutionExtension;
import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="build-frontend", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class BuildFrontendMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private LifecycleExecutionPlanCalculator executionPlanCalculator;
    @Parameter(property="cronapp.ide", defaultValue="false")
    private Boolean cronapp;
    @Parameter(property="cronapp.ignore.build.frontend", defaultValue="false")
    private Boolean ignoreBuildFrontend;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log logger = this.getLog();
        if (Boolean.TRUE.equals(this.cronapp) || Boolean.TRUE.equals(this.ignoreBuildFrontend)) {
            logger.info((CharSequence)"Ignoring BuildFrontendMojo Execution");
            return;
        }
        boolean hasWebapp = new File(this.mavenProject.getBasedir(), "src/main/webapp/package.json").exists();
        boolean hasMobileapp = new File(this.mavenProject.getBasedir(), "src/main/mobileapp/www/package.json").exists();
        if (hasMobileapp || hasWebapp) {
            logger.info((CharSequence)"Installing Node and NPM");
            Plugin frontendPlugin = new Plugin();
            frontendPlugin.setGroupId("com.github.eirslett");
            frontendPlugin.setArtifactId("frontend-maven-plugin");
            frontendPlugin.setVersion("1.14.2");
            try {
                PluginDescriptor frontendPluginDescriptor = this.pluginManager.loadPlugin(frontendPlugin, this.mavenProject.getRemotePluginRepositories(), this.mavenSession.getRepositorySession());
                MojoExecution installNodeMojoExecution = new MojoExecution(frontendPluginDescriptor.getMojo("install-node-and-npm"), MojoExecutionExtension.addChild(MojoExecutionExtension.addChild(new Xpp3Dom("configuration"), "nodeVersion", "v12.22.12"), "installDirectory", "target"));
                MojoExecution npmInstallWebMojoExecution = new MojoExecution(frontendPluginDescriptor.getMojo("npm"), MojoExecutionExtension.addChild(MojoExecutionExtension.addChild(new Xpp3Dom("configuration"), "workingDirectory", "src/main/webapp"), "installDirectory", "target"));
                MojoExecution npmInstallMobileMojoExecution = new MojoExecution(frontendPluginDescriptor.getMojo("npm"), MojoExecutionExtension.addChild(MojoExecutionExtension.addChild(new Xpp3Dom("configuration"), "workingDirectory", "src/main/mobileapp/www"), "installDirectory", "target"));
                this.executionPlanCalculator.setupMojoExecution(this.mavenSession, this.mavenProject, installNodeMojoExecution);
                this.pluginManager.executeMojo(this.mavenSession, installNodeMojoExecution);
                if (hasWebapp) {
                    this.executionPlanCalculator.setupMojoExecution(this.mavenSession, this.mavenProject, npmInstallWebMojoExecution);
                    this.pluginManager.executeMojo(this.mavenSession, npmInstallWebMojoExecution);
                }
                if (hasMobileapp) {
                    this.executionPlanCalculator.setupMojoExecution(this.mavenSession, this.mavenProject, npmInstallMobileMojoExecution);
                    this.pluginManager.executeMojo(this.mavenSession, npmInstallMobileMojoExecution);
                }
                logger.info((CharSequence)"Front end built successfully!");
            }
            catch (LifecycleNotFoundException | LifecyclePhaseNotFoundException | InvalidPluginDescriptorException | MojoNotFoundException | PluginConfigurationException | PluginDescriptorParsingException | PluginManagerException | PluginNotFoundException | PluginResolutionException | NoPluginFoundForPrefixException | PluginVersionResolutionException e) {
                logger.error((CharSequence)"Unable to execute the frontend build plugin in the project", e);
            }
        }
    }
}

