/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.cronapp.AbstractGenerateFiles;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="generate-blockly-js", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateBlocklyJsMojo
extends AbstractGenerateFiles {
    private static List<String> localesKeys = new ArrayList<String>();
    private static JsonObject localesRef = new JsonObject();
    private static boolean hasPtBr = false;
    private static JsonObject appConfig;
    private final List<String> ignoredPaths = List.of(File.separator + "node_modules" + File.separator, File.separator + "plugins" + File.separator);

    public void execute() {
        if (this.isCronappIDE()) {
            return;
        }
        if (this.getForStatic().booleanValue()) {
            this.setTarget(new File(this.getTarget().getAbsolutePath() + AbstractGenerateFiles.STATIC_OUTPUT_FOLDER));
        }
        this.getLog().info((CharSequence)"Starting generate-blockly-js Goal");
        if (this.getMavenProject() != null) {
            try {
                String blocklyJsFile = "/js/blockly.js";
                File mobileProject = this.getMobileProject();
                File webProject = this.getWebProject();
                if (mobileProject.exists()) {
                    GenerateBlocklyJsMojo.fillLanguages(mobileProject.toPath());
                    String mobileBlocklyJs = this.getBlocklyJsFileContent(mobileProject);
                    this.createFileForMobile(mobileBlocklyJs, blocklyJsFile);
                    this.getLog().info((CharSequence)"Goal generate-blockly-js mobileProject");
                }
                if (webProject.exists()) {
                    GenerateBlocklyJsMojo.fillLanguages(webProject.toPath());
                    String webBlocklyJs = this.getBlocklyJsFileContent(webProject);
                    this.createFileForWeb(webBlocklyJs, blocklyJsFile);
                    this.getLog().info((CharSequence)"Goal generate-blockly-js webProject");
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Could not save blockly.js file", (Throwable)e);
            }
            this.getLog().info((CharSequence)"Goal generate-blockly-js finished");
        } else {
            this.getLog().error((CharSequence)"Maven project was not found");
        }
    }

    private boolean containsIgnoredPath(String fileName) {
        return this.ignoredPaths.stream().anyMatch(fileName::contains);
    }

    public List<File> getBlocklyFiles(File parentFolder) {
        ArrayList<File> fileList = new ArrayList<File>();
        FileUtils.listFiles((File)parentFolder, (String[])new String[]{"blockly"}, (boolean)true).forEach(blockly -> {
            File blocklySource = new File(blockly.getPath() + ".js");
            if (blocklySource.exists() && !this.containsIgnoredPath(blocklySource.getAbsolutePath())) {
                fileList.add(blocklySource);
            }
        });
        return fileList;
    }

    private String getBlocklyJsFileContent(File parentFolder) {
        String localesKeysString = this.arrayToString(localesKeys) + ";";
        String localesRefString = localesRef.toString() + ";";
        StringBuilder blocklyJsFileContent = new StringBuilder();
        blocklyJsFileContent.append("window.fixedTimeZone = ").append(this.getValue(this.getAppConfig().get("fixedTimeZone"), true)).append(";\n").append("window.timeZone = '").append(this.getValue(this.getAppConfig().get("timeZone"), "UTC")).append("';\n").append("window.timeZoneOffset = ").append(this.getValue(this.getAppConfig().get("timeZoneOffset"), 0)).append(";\n").append("window.blockly = window.blockly || {};\n").append("window.blockly.js = window.blockly.js || {};\n").append("window.blockly.js.blockly = window.blockly.js.blockly || {};\n").append("window.translations = window.translations || {};\n").append("window.translations.localesKeys = ").append(localesKeysString).append("\n").append("window.translations.localesRef =  ").append(localesRefString).append("\n");
        this.getBlocklyFiles(parentFolder).forEach(blocklyFile -> {
            String scriptSrc = this.getImportScriptSrc(blocklyFile.toPath(), parentFolder.toPath());
            if (StringUtils.isNotEmpty((CharSequence)scriptSrc)) {
                blocklyJsFileContent.append("document.write(\"<script charset='" + Charset.defaultCharset() + "' src='").append(scriptSrc).append("'></script>\");\n");
            }
        });
        return blocklyJsFileContent.toString();
    }

    private Object getValue(JsonElement value, Object defaultValue) {
        if (value == null || value.isJsonNull()) {
            return defaultValue;
        }
        if (value.isJsonPrimitive()) {
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            if (primitive.isString()) {
                return value.getAsString();
            }
            if (primitive.isBoolean()) {
                return value.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return value.getAsInt();
            }
        }
        return value;
    }

    private String arrayToString(List<String> stringList) {
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (String key : stringList) {
            if (stringList.indexOf(key) != 0) {
                b.append(",");
            }
            b.append("'").append(key).append("'");
        }
        b.append("]");
        return b.toString();
    }

    private JsonObject getAppConfig() {
        if (appConfig != null) {
            return appConfig;
        }
        File appConfigFile = new File(this.getMavenProject().getBasedir(), "config/app.config");
        if (appConfigFile.exists()) {
            try {
                appConfig = new JsonParser().parse(Files.readString(appConfigFile.toPath())).getAsJsonObject();
                return appConfig;
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Could not get app.config file content", (Throwable)e);
            }
        }
        return new JsonObject();
    }

    private static void fillLanguages(Path folder) throws IOException {
        localesKeys = new ArrayList<String>();
        localesRef = new JsonObject();
        Path i18nPath = folder.resolve("i18n");
        if (!Files.exists(i18nPath, new LinkOption[0])) {
            return;
        }
        hasPtBr = false;
        try (Stream<Path> stream = Files.walk(i18nPath, new FileVisitOption[0]);){
            stream.map(path -> path.getFileName().toString()).filter(GenerateBlocklyJsMojo::isValidLocalePath).forEach(GenerateBlocklyJsMojo::addLocale);
        }
        if (hasPtBr) {
            localesRef.addProperty("*", "pt_br");
        }
    }

    private static boolean isValidLocalePath(String path) {
        return path.startsWith("locale") && path.endsWith(".json");
    }

    private static void addLocale(String path) {
        String localeName = path.substring(7, path.length() - 5);
        GenerateBlocklyJsMojo.fillLanguageSet(localeName);
    }

    private static void fillLanguageSet(String localeName) {
        if (!localesKeys.contains(localeName)) {
            localesKeys.add(localeName);
        }
        localesRef.addProperty(localeName.substring(0, 2) + "*", localeName);
        if (localeName.equals("pt_br")) {
            hasPtBr = true;
        }
    }

    private String getImportScriptSrc(Path blocklyFilePath, Path parentFolder) {
        Object hash = "";
        try {
            BasicFileAttributes attributes = Files.readAttributes(blocklyFilePath, BasicFileAttributes.class, new LinkOption[0]);
            if (attributes.isDirectory()) {
                return "";
            }
            FileTime lastModifiedTime = attributes.lastModifiedTime();
            if (lastModifiedTime != null) {
                hash = "?" + attributes.lastModifiedTime().toMillis();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error getting path attributes", (Throwable)e);
        }
        String pathString = parentFolder.relativize(blocklyFilePath).toString();
        if (pathString.endsWith(".blockly.js")) {
            String js = pathString.replace("\\", "/");
            if (js.startsWith("/")) {
                js = js.substring(1);
            }
            return js + (String)hash;
        }
        return "";
    }
}

