/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.cronapp.AbstractGenerateFiles;
import io.cronapp.ContextManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-host-app", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateHostApp
extends AbstractGenerateFiles {
    @Parameter(property="cronapp.hostApp")
    protected String hostApp;

    public void execute() {
        Path contextPath;
        if (this.getForStatic().booleanValue()) {
            this.setTarget(new File(this.getTarget().getAbsolutePath() + AbstractGenerateFiles.STATIC_OUTPUT_FOLDER));
        }
        boolean fromContext = false;
        boolean isHostAppBlank = StringUtils.isBlank((CharSequence)this.hostApp);
        if (isHostAppBlank && Files.exists(contextPath = this.getMavenProject().getBasedir().toPath().resolve("config").resolve("context.xml"), new LinkOption[0])) {
            ContextManager contextManager = null;
            try (InputStream in = Files.newInputStream(contextPath, new OpenOption[0]);){
                contextManager = new ContextManager(in);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Could not read context.xml file", (Throwable)e);
            }
            if (contextManager != null) {
                try {
                    String tokenAuthUrl = contextManager.getParameterValue("crn.config.tokenAuthUrl");
                    if (!StringUtils.isBlank((CharSequence)tokenAuthUrl)) {
                        this.hostApp = tokenAuthUrl.replaceAll("^(http[s]?://[^/]+).*", "$1");
                    }
                    isHostAppBlank = fromContext = StringUtils.isBlank((CharSequence)this.hostApp);
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)"Could not read crn.config.tokenAuthUrl parameter from context.xml file", (Throwable)e);
                }
            }
        }
        String string = this.hostApp = isHostAppBlank ? this.hostApp : StringUtils.appendIfMissing((String)this.hostApp, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        if (this.isCronappIDE() && !fromContext) {
            return;
        }
        this.getLog().info((CharSequence)"Starting generate-host-app Goal");
        if (this.getMavenProject() != null) {
            try {
                String hostAppJsFile = "/js/hostApp.js";
                String hostAppJsContent = isHostAppBlank ? "window.hostApp = '../';" : "window.hostApp = '" + this.hostApp + "';\nwindow.disableServerCookies = true;";
                String hostWebContent = isHostAppBlank ? "window.hostApp = '';" : "window.hostApp = '" + this.hostApp + "';\nwindow.disableServerCookies = true;";
                this.createFileForMobile(hostAppJsContent, hostAppJsFile);
                this.createFileForWeb(hostWebContent, hostAppJsFile);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Could not save hostApp.js file", (Throwable)e);
            }
            this.getLog().info((CharSequence)"Goal generate-host-app finished");
        } else {
            this.getLog().error((CharSequence)"Maven project was not found");
        }
    }
}

