/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="generate-openapi-client", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class GenerateOpenApiClientMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private LifecycleExecutionPlanCalculator executionPlanCalculator;

    private static void addChildValue(Xpp3Dom parent, String name, String value) {
        Xpp3Dom child = new Xpp3Dom(name);
        child.setValue(value);
        parent.addChild(child);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        this.getLog().info((CharSequence)"OpenAPI client generation: Starting");
        Plugin compilePlugin = (Plugin)this.mavenProject.getPluginManagement().getPluginsAsMap().get("io.cronapp:cronapp-compile-plugin");
        if (compilePlugin == null) {
            throw new MojoFailureException("Unable to find compile plugin in the project");
        }
        String frameworkVersion = compilePlugin.getVersion();
        try {
            List inputSpecFiles;
            File basedir = this.mavenProject.getBasedir();
            Path inputSpecPath = Path.of(basedir.getAbsolutePath(), "src", "main", "api-specs", "openapi");
            if (!Files.exists(inputSpecPath, new LinkOption[0])) {
                log.info((CharSequence)"Skipping OpenAPI client generation: spec directory not found");
                return;
            }
            try (Stream<Path> inputSpecStream = Files.list(inputSpecPath);){
                inputSpecFiles = inputSpecStream.collect(Collectors.toList());
            }
            if (inputSpecFiles.isEmpty()) {
                log.info((CharSequence)"Skipping OpenAPI client generation: spec directory is empty");
                return;
            }
            Plugin generatorPlugin = new Plugin();
            generatorPlugin.setGroupId("org.openapitools");
            generatorPlugin.setArtifactId("openapi-generator-maven-plugin");
            generatorPlugin.setVersion("6.6.0");
            Dependency generatorPluginDependency = new Dependency();
            generatorPluginDependency.setGroupId("io.cronapp");
            generatorPluginDependency.setArtifactId("cronapp-openapi-generator");
            generatorPluginDependency.setVersion(frameworkVersion);
            generatorPlugin.setDependencies(List.of(generatorPluginDependency));
            PluginDescriptor generatorPluginDescriptor = this.pluginManager.loadPlugin(generatorPlugin, this.mavenProject.getRemotePluginRepositories(), this.mavenSession.getRepositorySession());
            MojoDescriptor generatorMojoDescriptor = generatorPluginDescriptor.getMojo("generate");
            Path generatedSourcesPath = Paths.get(this.mavenProject.getBuild().getDirectory(), "generated-sources");
            for (Path inputSpecFile : inputSpecFiles) {
                Xpp3Dom configuration = new Xpp3Dom("configuration");
                String executionId = FilenameUtils.getBaseName((String)inputSpecFile.toString());
                String output = generatedSourcesPath.resolve(executionId).toString();
                GenerateOpenApiClientMojo.addChildValue(configuration, "inputSpec", inputSpecFile.toString());
                GenerateOpenApiClientMojo.addChildValue(configuration, "output", output);
                GenerateOpenApiClientMojo.addChildValue(configuration, "generatorName", "cronapp.framework.openapi.codegen.CronapiJavaCodegen");
                GenerateOpenApiClientMojo.addChildValue(configuration, "library", "webclient");
                GenerateOpenApiClientMojo.addChildValue(configuration, "openApiNullable", Boolean.TRUE.toString());
                GenerateOpenApiClientMojo.addChildValue(configuration, "skipValidateSpec", Boolean.TRUE.toString());
                Xpp3Dom configOptions = new Xpp3Dom("configOptions");
                configuration.addChild(configOptions);
                OpenAPI openAPI = new OpenAPIParser().readContents(Files.readString(inputSpecFile), List.of(), new ParseOptions()).getOpenAPI();
                String namespace = openAPI.getExtensions().getOrDefault("x-cronapp-namespace", "").toString();
                if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                    GenerateOpenApiClientMojo.addChildValue(configuration, "invokerPackage", namespace);
                    GenerateOpenApiClientMojo.addChildValue(configuration, "apiPackage", namespace + ".api");
                    GenerateOpenApiClientMojo.addChildValue(configuration, "modelPackage", namespace + ".model");
                    GenerateOpenApiClientMojo.addChildValue(configOptions, "blockPackage", namespace + ".block");
                }
                GenerateOpenApiClientMojo.addChildValue(configuration, "modelNameSuffix", "Model");
                MojoExecution generatorMojoExecution = new MojoExecution(generatorMojoDescriptor, configuration);
                this.executionPlanCalculator.setupMojoExecution(this.mavenSession, this.mavenProject, generatorMojoExecution);
                this.pluginManager.executeMojo(this.mavenSession, generatorMojoExecution);
                Resource resource = new Resource();
                resource.setDirectory(Paths.get(output, "src", "main", "resources").toString());
                this.mavenProject.addResource(resource);
            }
        }
        catch (Throwable e) {
            throw new MojoFailureException("Error running OpenAPI client generation", e);
        }
    }
}

