/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-token-registrations", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class GenerateTokenRegistrationsMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Token registration generation: Starting");
        Path configPath = Paths.get(this.mavenProject.getBasedir().getAbsolutePath(), "config", "tokenRegistration.config");
        if (!Files.exists(configPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)"Token registration generation: Skipping");
            return;
        }
        try {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_30);
            configuration.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "/");
            Template template = configuration.getTemplate("templates/tokenRegistration.properties.ftl");
            ObjectMapper objectMapper = new ObjectMapper();
            MapType type = objectMapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
            Object bundle = objectMapper.readValue(configPath.toFile(), (JavaType)type);
            Path resourcesPath = Path.of(this.mavenProject.getBuild().getDirectory(), "generated-resources", "token-registrations");
            Path outputPath = Path.of(resourcesPath.toString(), "config", "cronapp");
            if (!Files.exists(outputPath, new LinkOption[0])) {
                Files.createDirectories(outputPath, new FileAttribute[0]);
            }
            Path propertiesPath = Path.of(outputPath.toString(), "tokenRegistration.properties");
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(propertiesPath, new OpenOption[0]));){
                template.process(bundle, (Writer)writer);
            }
            Resource resource = new Resource();
            resource.setDirectory(resourcesPath.toString());
            this.mavenProject.addResource(resource);
        }
        catch (TemplateException | IOException e) {
            throw new MojoFailureException("Token registration generation: Failure", e);
        }
        this.getLog().info((CharSequence)"Token registration generation: Finished");
    }
}

