/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jar.JarMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Mojo(name="cronapp-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class LibraryMojo
extends JarMojo {
    private static final String LIBRARY = "library";
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="project", required=true, readonly=false)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Component
    private Map<String, Archiver> archivers;
    @Parameter(property="cronapp.type")
    private String cronappType;
    @Parameter(property="cronapp.subscription")
    private String cronappSubscription;
    @Parameter(property="cronapp.ide", defaultValue="false")
    protected Boolean cronapp;
    private final List<String> includeList = new ArrayList<String>();

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public String getCronappType() {
        return this.cronappType;
    }

    public String getCronappSubscription() {
        return this.cronappSubscription;
    }

    private boolean isCronappTypeLibrary() {
        return LIBRARY.equals(this.cronappType);
    }

    private boolean isValidCronappSubscription() {
        return this.cronappSubscription != null && !this.cronappSubscription.isEmpty() && !this.cronappSubscription.isBlank();
    }

    private void includeBlocks() throws MojoExecutionException {
        File directory = Path.of(this.getMavenProject().getBasedir().getAbsolutePath(), "src", "main", "java").toFile();
        if (directory.exists() && directory.isDirectory()) {
            this.recursiveIncludeBlocks(directory);
        }
    }

    private void recursiveIncludeBlocks(File directory) throws MojoExecutionException {
        for (File blockly : directory.listFiles()) {
            if (blockly.isDirectory()) {
                this.recursiveIncludeBlocks(blockly);
                continue;
            }
            if (!blockly.isFile() || !blockly.getName().endsWith(".blockly")) continue;
            try {
                Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(blockly);
                if (!xml.getDocumentElement().hasAttribute(LIBRARY) || !Boolean.valueOf(xml.getDocumentElement().getAttribute(LIBRARY)).booleanValue()) continue;
                String filepath = blockly.getAbsolutePath();
                filepath = filepath.substring(filepath.indexOf("src/main/java") + 14, filepath.length() - 8);
                filepath = this.normalizeJavaFileName(filepath);
                this.includeList.add(filepath + ".class");
                this.includeList.add(filepath + "$*.class");
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new MojoExecutionException("Error reading datasource file = " + blockly.getName(), e);
            }
        }
    }

    private void includeDataSources() throws MojoExecutionException {
        File baseDirDataSources = Path.of(this.getMavenProject().getBasedir().getAbsolutePath(), "src", "main", "java", "META-INF", "datasources").toFile();
        if (baseDirDataSources.exists() && baseDirDataSources.isDirectory()) {
            for (File datasourceFile : baseDirDataSources.listFiles()) {
                if (!datasourceFile.isFile() || !datasourceFile.getName().endsWith(".datasource.json")) continue;
                try {
                    JsonObject json = new JsonParser().parse(Files.readString(datasourceFile.toPath())).getAsJsonObject();
                    if (!json.has(LIBRARY) || !json.get(LIBRARY).getAsBoolean()) continue;
                    this.includeList.add("META-INF/datasources/" + datasourceFile.getName());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading datasource file = " + datasourceFile.getName(), (Exception)e);
                }
            }
        }
    }

    private boolean hasLibraryItens() {
        return !this.includeList.isEmpty();
    }

    private String normalizeJavaFileName(String name) {
        int i;
        Object filename;
        String path = "";
        Object object = filename = name != null ? name : "";
        if (((String)filename).contains(File.separator)) {
            i = ((String)filename).lastIndexOf(File.separator) + 1;
            if (((String)filename).length() > i) {
                path = ((String)filename).substring(0, i);
                filename = ((String)filename).substring(i);
            } else {
                path = filename;
                filename = "";
            }
        }
        if (!((String)filename).isEmpty()) {
            filename = this.removerAcentos((String)filename);
            filename = Pattern.compile("\\W").matcher((CharSequence)filename).replaceAll(" ").trim();
            filename = Pattern.compile("^[\\d\\W]+").matcher((CharSequence)filename).replaceAll(" ").trim();
            if (((String)(filename = ((String)filename).replaceAll("\\s{2,}", " ").replaceAll("_", " ").trim())).length() > 0) {
                filename = ((String)filename).substring(0, 1).toUpperCase() + ((String)filename).substring(1);
            }
            while (((String)filename).contains(" ")) {
                i = ((String)filename).indexOf(" ");
                filename = ((String)filename).substring(0, i) + this.firstToUpper(((String)filename).substring(i + 1));
            }
        }
        return path + (String)filename;
    }

    private String removerAcentos(String value) {
        String CHR_ACENTUADA = "\u00e0\u00e8\u00ec\u00f2\u00f9\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00ee\u00f4\u00fb\u00e3\u00f5\u00e7\u00f1\u00e4\u00eb\u00ef\u00f6\u00fc\u00c0\u00c8\u00cc\u00d2\u00d9\u00c1\u00c9\u00cd\u00d3\u00da\u00c2\u00ca\u00ce\u00d4\u00db\u00c3\u00d5\u00c7\u00d1\u00c4\u00cb\u00cf\u00d6\u00dc";
        String CHR_NAO_ACENTUADA = "aeiouaeiouaeiouaocnaeiouAEIOUAEIOUAEIOUAOCNAEIOU";
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            int iAcentuado = "\u00e0\u00e8\u00ec\u00f2\u00f9\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00ee\u00f4\u00fb\u00e3\u00f5\u00e7\u00f1\u00e4\u00eb\u00ef\u00f6\u00fc\u00c0\u00c8\u00cc\u00d2\u00d9\u00c1\u00c9\u00cd\u00d3\u00da\u00c2\u00ca\u00ce\u00d4\u00db\u00c3\u00d5\u00c7\u00d1\u00c4\u00cb\u00cf\u00d6\u00dc".indexOf(value.charAt(i));
            if (iAcentuado != -1) {
                result.append("aeiouaeiouaeiouaocnaeiouAEIOUAEIOUAEIOUAOCNAEIOU".charAt(iAcentuado));
                continue;
            }
            result.append(value.charAt(i));
        }
        return result.toString();
    }

    private String firstToUpper(String value) {
        if (value == null) {
            return "";
        }
        if ((value = value.trim()).length() == 1) {
            return value.toUpperCase();
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
    }

    public void execute() throws MojoExecutionException {
        if (this.cronapp.booleanValue()) {
            return;
        }
        if (this.isCronappTypeLibrary()) {
            if (!this.isValidCronappSubscription()) {
                throw new MojoExecutionException("You must inform cronapp.subscription when you use cronapp.type=library.");
            }
            this.includeBlocks();
            this.includeDataSources();
            if (!this.hasLibraryItens()) {
                throw new MojoExecutionException("Project has no library items.");
            }
            String newGroupId = "io.cronapp.plugins." + this.getCronappSubscription();
            this.getMavenProject().setGroupId(newGroupId);
            this.getMavenProject().getArtifact().setGroupId(newGroupId);
            if ("jar".equals(this.getMavenProject().getPackaging())) {
                this.getMavenProject().getArtifact().setFile(this.createArchive());
            } else {
                this.projectHelper.attachArtifact(this.getMavenProject(), this.getType(), null, this.createArchive());
                this.getMavenProject().getArtifact().setFile(null);
            }
        }
    }

    public File createArchive() throws MojoExecutionException {
        File jarFile = this.getJarFile(this.outputDirectory, this.finalName, this.getClassifier());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setCreatedBy("Maven JAR Plugin", "org.apache.maven.plugins", "maven-jar-plugin");
        archiver.setArchiver((JarArchiver)this.archivers.get("jar"));
        archiver.setOutputFile(jarFile);
        archiver.configureReproducible(this.outputTimestamp);
        try {
            File contentDirectory = this.getClassesDirectory();
            if (contentDirectory.exists()) {
                archiver.getArchiver().addDirectory(contentDirectory, (String[])this.includeList.toArray(String[]::new), new String[0]);
            }
            archiver.createArchive(this.session, this.getProject(), this.archive);
            return jarFile;
        }
        catch (IOException | DependencyResolutionRequiredException | ArchiverException | ManifestException e) {
            throw new MojoExecutionException("Error assembling JAR", (Exception)e);
        }
    }
}

