/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="verify-owasp", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class OWASPMojo
extends AbstractMojo {
    private static final SimpleDateFormat FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    @Parameter(property="cronapp.owasp.active", defaultValue="false")
    private Boolean active;
    @Parameter(property="cronapp.owasp.fail.on.any.vulnerability", defaultValue="false")
    private Boolean failOnAnyVulnerability;
    @Parameter(property="cronapp.owasp.use.suppression.file.framework", defaultValue="false")
    private Boolean useSuppressionFileFramework;
    @Parameter(property="cronapp.owasp.use.suppression.file.local", defaultValue="false")
    private Boolean useSuppressionFileLocal;
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private LifecycleExecutionPlanCalculator executionPlanCalculator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (!this.active.booleanValue()) {
            log.info((CharSequence)"Cronapp OWASP: Inactived!");
            return;
        }
        log.info((CharSequence)"Cronapp OWASP: Starting");
        String now = FORMAT_DATE.format(System.currentTimeMillis());
        Plugin compilePlugin = (Plugin)this.mavenProject.getPluginManagement().getPluginsAsMap().get("io.cronapp:cronapp-compile-plugin");
        if (compilePlugin == null) {
            throw new MojoFailureException("Unable to find compile plugin in the project");
        }
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.owasp");
        plugin.setArtifactId("dependency-check-maven");
        plugin.setVersion("8.4.0");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        OWASPMojo.addChildValue(configuration, "assemblyAnalyzerEnabled", "false");
        OWASPMojo.addChildValue(configuration, "centralAnalyzerUseCache", "false");
        OWASPMojo.addChildValue(configuration, "nodeAuditAnalyzerUseCache", "false");
        OWASPMojo.addChildValue(configuration, "ossindexAnalyzerUseCache", "false");
        if (this.failOnAnyVulnerability.booleanValue()) {
            OWASPMojo.addChildValue(configuration, "failBuildOnAnyVulnerability", "true");
        }
        boolean existsLocalSuppressFile = Files.exists(Path.of(this.mavenProject.getBasedir().getAbsolutePath(), "owasp-suppression-file.xml"), new LinkOption[0]);
        if (this.useSuppressionFileFramework.booleanValue() || this.useSuppressionFileLocal.booleanValue() && existsLocalSuppressFile) {
            Xpp3Dom suppressionFiles = new Xpp3Dom("suppressionFiles");
            if (this.useSuppressionFileFramework.booleanValue()) {
                Dependency dependency = new Dependency();
                dependency.setGroupId("io.cronapp");
                dependency.setArtifactId("cronapp-compile-plugin");
                dependency.setVersion(compilePlugin.getVersion());
                plugin.addDependency(dependency);
                OWASPMojo.addChildValue(suppressionFiles, "suppressionFile", "cronapp-owasp-suppression-file.xml");
            }
            if (this.useSuppressionFileLocal.booleanValue() && existsLocalSuppressFile) {
                OWASPMojo.addChildValue(suppressionFiles, "suppressionFile", "owasp-suppression-file.xml");
            }
            configuration.addChild(suppressionFiles);
        }
        try {
            MojoDescriptor checkMojoPlugin = this.pluginManager.loadPlugin(plugin, this.mavenProject.getRemotePluginRepositories(), this.mavenSession.getRepositorySession()).getMojo("check");
            MojoExecution checkMojoExecution = new MojoExecution(checkMojoPlugin, configuration);
            this.executionPlanCalculator.setupMojoExecution(this.mavenSession, this.mavenProject, checkMojoExecution);
            this.pluginManager.executeMojo(this.mavenSession, checkMojoExecution);
            Path reportFile = Path.of(this.mavenProject.getBuild().getDirectory(), "dependency-check-report.html");
            if (Files.exists(reportFile, new LinkOption[0])) {
                Path docDir = Path.of(this.mavenProject.getBasedir().getAbsolutePath(), "docs", "OWASP");
                Files.createDirectories(docDir, new FileAttribute[0]);
                Files.move(reportFile, Path.of(docDir.toString(), "dependency-check-report-" + now + ".html"), new CopyOption[0]);
            }
        }
        catch (IOException | LifecycleNotFoundException | LifecyclePhaseNotFoundException | InvalidPluginDescriptorException | MojoNotFoundException | PluginConfigurationException | PluginDescriptorParsingException | PluginManagerException | PluginNotFoundException | PluginResolutionException | NoPluginFoundForPrefixException | PluginVersionResolutionException e) {
            throw new MojoFailureException("Error running Cronapp OWASP", e);
        }
        log.info((CharSequence)"Cronapp OWASP: Finished!");
    }

    private static void addChildValue(Xpp3Dom parent, String name, String value) {
        Xpp3Dom child = new Xpp3Dom(name);
        child.setValue(value);
        parent.addChild(child);
    }
}

