/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.cronapp.AbstractGenerateFiles;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="package-listener", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class PackageListenerMojo
extends AbstractGenerateFiles {
    @Parameter(property="cronapp.mobileapp", defaultValue="false")
    protected Boolean mobileApp;
    @Parameter(property="cronapp.ide", defaultValue="false")
    protected Boolean cronapp;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.cronapp.booleanValue()) {
            return;
        }
        if (this.mobileApp.booleanValue()) {
            if (this.getMavenProject() != null) {
                try {
                    this.handleMobileapp(this.getExplodedFolder().toPath());
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                this.getLog().info((CharSequence)"Goal package-listener finished");
            } else {
                this.getLog().error((CharSequence)"Maven project was not found");
            }
        }
    }

    private void handleMobileapp(Path root) throws IOException {
        Path source = this.getMavenProject().getBasedir().toPath().resolve("src").resolve("main").resolve("mobileapp").resolve("www");
        if (!Files.exists(source, new LinkOption[0])) {
            return;
        }
        Path target = root.resolve("mobileapp");
        this.getLog().info((CharSequence)("Including " + source));
        this.copyFolder(source, target, StandardCopyOption.REPLACE_EXISTING);
    }

    public void copyFolder(final Path source, final Path target, final CopyOption ... options) throws IOException {
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(target.resolve(source.relativize(dir).toString()), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (source.relativize(file).toString().equals("js/hostApp.js") && Files.exists(target.resolve(source.relativize(file).toString()), new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                Files.copy(file, target.resolve(source.relativize(file).toString()), options);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

