/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="process-artifact", defaultPhase=LifecyclePhase.PACKAGE)
public class ProcessArtifactMojo
extends AbstractMojo {
    private Configuration cfg;
    private LinkedHashMap<String, Object> dataModel;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="cronapp.artifactType", defaultValue="all")
    private String artifactType;
    @Parameter(property="cronapp.dockerfile", defaultValue="false")
    private String dockerfile;
    @Parameter(property="cronapp.privkey")
    private String privkey;
    @Parameter(property="cronapp.fullChain")
    private String fullchain;
    @Parameter(property="cronapp.removeCertificate", defaultValue="false")
    private String removeCertificate;
    @Parameter(property="cronapp.gzip", defaultValue="on")
    private String gzip;
    @Parameter(property="cronapp.timezone", defaultValue="America/Fortaleza")
    private String timezone;
    @Parameter(property="cronapp.hostApp", defaultValue="")
    private String hostApp;
    @Parameter(property="cronapp.mem", defaultValue="80")
    private String mem;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.hostApp = StringUtils.isBlank((CharSequence)this.hostApp) ? this.hostApp : StringUtils.appendIfMissing((String)this.hostApp, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        File targetFolder = new File(this.project.getBuild().getDirectory());
        File jarFile = new File(targetFolder, this.project.getBuild().getFinalName() + ".war");
        Path zipFile = targetFolder.toPath().resolve(this.project.getBuild().getFinalName() + ".zip");
        Path dockerZipFile = targetFolder.toPath().resolve(this.project.getBuild().getFinalName() + "-docker.zip");
        try {
            Files.deleteIfExists(zipFile);
            Files.deleteIfExists(dockerZipFile);
            URI zipURI = new URI("jar", jarFile.toURI().toString(), null);
            HashMap<String, String> zipProperties = new HashMap<String, String>();
            zipProperties.put("create", "false");
            try (FileSystem zipFS = FileSystems.newFileSystem(zipURI, zipProperties);){
                this.handleArtifactType(zipFS);
            }
            if (this.artifactType.equals("front-end-zip")) {
                Files.move(jarFile.toPath(), zipFile, new CopyOption[0]);
            }
            if (this.dockerfile != null && this.dockerfile.equalsIgnoreCase("true")) {
                this.cfg = new Configuration();
                this.cfg.setDefaultEncoding("UTF-8");
                this.cfg.setOutputEncoding("UTF-8");
                File dockerFile = new File(targetFolder, "Dockerfile");
                File runSh = new File(targetFolder, "run.sh");
                File runBat = new File(targetFolder, "run.bat");
                File privkeyFile = new File(targetFolder, "privkey.pem");
                File fullChainFile = new File(targetFolder, "fullchain.pem");
                privkeyFile.delete();
                fullChainFile.delete();
                runSh.delete();
                runBat.delete();
                this.dataModel = new LinkedHashMap();
                if (StringUtils.isNotBlank((CharSequence)this.privkey)) {
                    this.getLog().info((CharSequence)"Creating privkey");
                    this.dataModel.put("privkey", true);
                    Files.copy(Path.of(this.privkey, new String[0]), privkeyFile.toPath(), new CopyOption[0]);
                    if (this.removeCertificate.equalsIgnoreCase("true")) {
                        Files.deleteIfExists(Path.of(this.privkey, new String[0]));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)this.fullchain)) {
                    this.getLog().info((CharSequence)"Creating fullchain");
                    this.dataModel.put("fullchain", true);
                    Files.copy(Path.of(this.fullchain, new String[0]), fullChainFile.toPath(), new CopyOption[0]);
                    if (this.removeCertificate.equalsIgnoreCase("true")) {
                        Files.deleteIfExists(Path.of(this.fullchain, new String[0]));
                    }
                }
                this.dataModel.put("gzip", this.gzip);
                this.dataModel.put("timezone", this.timezone);
                this.dataModel.put("mem", this.mem);
                this.dataModel.put("isSSL", StringUtils.isNotEmpty((CharSequence)this.fullchain));
                this.dataModel.put("version", "1.0.0");
                this.dataModel.put("hostApp", StringUtils.defaultString((String)this.hostApp, (String)""));
                this.dataModel.put("isZip", String.valueOf(this.artifactType.equals("front-end-zip")));
                this.dataModel.put("artifactVersion", this.project.getArtifact().getBaseVersion());
                this.dataModel.put("artifact", this.project.getArtifact().getArtifactId());
                if (this.artifactType.equals("front-end-zip")) {
                    this.dataModel.put("war", zipFile.getFileName().toString());
                } else {
                    this.dataModel.put("war", jarFile.getName());
                }
                this.processTemplate("Dockerfile.ftl", dockerFile);
                this.processTemplate("run.sh.ftl", runSh);
                this.processTemplate("run.bat.ftl", runBat);
                this.getLog().info((CharSequence)("Creating " + dockerZipFile));
                LinkedList<File> zipList = new LinkedList<File>();
                zipList.add(dockerFile);
                if (this.artifactType.equals("front-end-zip")) {
                    zipList.add(zipFile.toFile());
                } else {
                    zipList.add(jarFile);
                }
                zipList.add(privkeyFile);
                zipList.add(fullChainFile);
                zipList.add(runSh);
                zipList.add(runBat);
                ProcessArtifactMojo.zip(zipList, dockerZipFile.toFile());
            }
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void processTemplate(String name, File dockerFile) throws IOException, TemplateException {
        try (InputStream stream = ProcessArtifactMojo.class.getClassLoader().getResourceAsStream(name);
             InputStreamReader reader = new InputStreamReader(stream);){
            Template template = new Template("expression", (Reader)reader, this.cfg);
            try (FileWriter writer = new FileWriter(dockerFile);){
                template.process(this.dataModel, (Writer)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(List<File> fileList, File toFile) throws Exception {
        toFile.delete();
        try (FileOutputStream fos = new FileOutputStream(toFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (File file : fileList) {
                if (!file.exists()) continue;
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zos.putNextEntry(zipEntry);
                try (FileInputStream stream = new FileInputStream(file);){
                    IOUtils.copy((InputStream)stream, (OutputStream)zos);
                }
                finally {
                    zos.closeEntry();
                }
            }
        }
    }

    private void handleArtifactType(FileSystem zipFS) throws IOException {
        if (this.artifactType.startsWith("front-end")) {
            Path org;
            Path metaInf;
            Path webInf = zipFS.getPath("WEB-INF", new String[0]);
            if (webInf != null) {
                this.removePath(webInf);
            }
            if ((metaInf = zipFS.getPath("META-INF", new String[0])) != null) {
                this.removePath(metaInf);
            }
            if ((org = zipFS.getPath("org", new String[0])) != null) {
                this.removePath(org);
            }
        }
        if (this.artifactType.equals("server")) {
            Files.list(zipFS.getRootDirectories().iterator().next()).collect(Collectors.toList()).forEach(path -> {
                if (!(path.getFileName().toString().equals("WEB-INF") || path.getFileName().toString().equals("META-INF") || path.getFileName().toString().equals("org"))) {
                    try {
                        this.getLog().info((CharSequence)("Removing " + path));
                        this.removePath((Path)path);
                    }
                    catch (IOException e1) {
                        this.getLog().error((Throwable)e1);
                    }
                }
            });
        }
    }

    private void removePath(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            Files.delete(path);
        }
    }
}

